"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _public = require("@kbn/kibana-react-plugin/public");
var _index_view_logic = require("../../index_view_logic");
var _connector_filtering_logic = require("./connector_filtering_logic");
var _doc_links = require("../../../shared/doc_links");
var _inline_editable_table_logic = require("../../../shared/tables/inline_editable_table/inline_editable_table_logic");
var _inline_editable_table = require("../../../shared/tables/inline_editable_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const instanceId = 'FilteringRulesTable';
function validateItem(filteringRule) {
  if (filteringRule.rule === 'regex') {
    try {
      new RegExp(filteringRule.value);
      return {};
    } catch {
      return {
        value: _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.filteringRules.regExError', {
          defaultMessage: 'Value should be a regular expression'
        })
      };
    }
  }
  return {};
}
const SyncRulesTable = () => {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    editableFilteringRules
  } = (0, _kea.useValues)((0, _connector_filtering_logic.ConnectorFilteringLogic)({
    http
  }));
  const {
    indexName
  } = (0, _kea.useValues)((0, _index_view_logic.IndexViewLogic)({
    http
  }));
  const {
    addFilteringRule,
    deleteFilteringRule,
    reorderFilteringRules,
    updateFilteringRule
  } = (0, _kea.useActions)((0, _connector_filtering_logic.ConnectorFilteringLogic)({
    http
  }));
  const description = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "default"
  }, _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.description', {
    defaultMessage: 'Add a sync rule to customize what data is synchronized from {indexName}. Everything is included by default, and documents are validated against the configured set of sync rules in the listed order.',
    values: {
      indexName
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.syncRules,
    external: true,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.link', {
    defaultMessage: 'Learn more about customizing your sync rules.'
  })));
  const columns = [{
    editingRender: (filteringRule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      fullWidth: true,
      value: filteringRule.policy,
      onChange: e => onChange(e.target.value),
      options: [{
        text: (0, _searchConnectors.filteringPolicyToText)('include'),
        value: 'include'
      }, {
        text: (0, _searchConnectors.filteringPolicyToText)('exclude'),
        value: 'exclude'
      }]
    }),
    field: 'policy',
    name: _i18n.i18n.translate('xpack.contentConnectors.index.connector.rule.basicTable.policyTitle', {
      defaultMessage: 'Policy'
    }),
    render: indexingRule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _searchConnectors.filteringPolicyToText)(indexingRule.policy))
  }, {
    editingRender: (rule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: rule.field,
      onChange: e => onChange(e.target.value)
    }))),
    field: 'field',
    name: _i18n.i18n.translate('xpack.contentConnectors.index.connector.syncRules.basicTable.fieldTitle', {
      defaultMessage: 'Field'
    }),
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, rule.field))
  }, {
    editingRender: (filteringRule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      fullWidth: true,
      value: filteringRule.rule,
      onChange: e => onChange(e.target.value),
      options: Object.values(_searchConnectors.FilteringRuleRuleValues).map(rule => ({
        text: (0, _searchConnectors.filteringRuleToText)(rule),
        value: rule
      }))
    }),
    field: 'rule',
    name: _i18n.i18n.translate('xpack.contentConnectors.index.connector.syncRules.basicTable.ruleTitle', {
      defaultMessage: 'Rule'
    }),
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _searchConnectors.filteringRuleToText)(rule.rule))
  }, {
    editingRender: (rule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: rule.value,
      onChange: e => onChange(e.target.value)
    }))),
    field: 'value',
    name: _i18n.i18n.translate('xpack.contentConnectors.index.connector.syncRules.basicTable.valueTitle', {
      defaultMessage: 'Value'
    }),
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, rule.value))
  }];
  return /*#__PURE__*/_react.default.createElement(_inline_editable_table.InlineEditableTable, {
    addButtonText: _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.table.addRuleLabel', {
      defaultMessage: 'Add sync rule'
    }),
    columns: columns,
    defaultItem: {
      policy: 'include',
      rule: 'equals',
      value: ''
    },
    description: description,
    instanceId: instanceId,
    items: editableFilteringRules,
    onAdd: rule => {
      const now = new Date().toISOString();
      const newRule = {
        ...rule,
        created_at: now,
        // crypto.randomUUID isn't widely enough available in browsers yet
        id: (0, _uuid.v4)(),
        updated_at: now
      };
      addFilteringRule(newRule);
      (0, _inline_editable_table_logic.InlineEditableTableLogic)({
        instanceId
      }).actions.doneEditing();
    },
    onDelete: deleteFilteringRule,
    onUpdate: rule => {
      updateFilteringRule(rule);
      (0, _inline_editable_table_logic.InlineEditableTableLogic)({
        instanceId
      }).actions.doneEditing();
    },
    onReorder: reorderFilteringRules,
    title: "",
    validateItem: validateItem,
    bottomRows: [/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.contentConnectors.content.sources.basicRulesTable.includeEverythingMessage', {
      defaultMessage: 'Include everything else from this source'
    }))],
    canRemoveLastItem: true,
    emptyPropertyAllowed: true,
    showRowIndex: true
  });
};
exports.SyncRulesTable = SyncRulesTable;