"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayoutConfigProvider = void 0;
exports.useLayoutConfig = useLayoutConfig;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Configuration for the layout.
 * @public
 */

const LayoutConfigContext = /*#__PURE__*/(0, _react.createContext)(undefined);

/**
 * Props for the LayoutConfigProvider component.
 * @public
 */

/**
 * Provider of the layout config
 * @public
 */
const LayoutConfigProvider = ({
  value,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(LayoutConfigContext.Provider, {
    value: value
  }, children);
};

/**
 * Hook to access the layout configuration.
 * @internal
 * @returns The current layout configuration
 * @throws Error if used outside of a LayoutConfigProvider
 */
exports.LayoutConfigProvider = LayoutConfigProvider;
function useLayoutConfig() {
  const context = (0, _react.useContext)(LayoutConfigContext);
  if (!context) {
    throw new Error('useLayoutConfig must be used within a LayoutConfigProvider');
  }
  return context;
}