"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeDataViewsManager = initializeDataViewsManager;
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _kibana_services = require("../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeDataViewsManager(controlGroupApi$, children$) {
  const dataViews$ = new _rxjs.BehaviorSubject([]);
  const controlGroupDataViewsPipe = controlGroupApi$.pipe((0, _rxjs.switchMap)(controlGroupApi => {
    return controlGroupApi ? controlGroupApi.dataViews$ : (0, _rxjs.of)([]);
  }));
  const childDataViewsPipe = (0, _presentationContainers.combineCompatibleChildrenApis)({
    children$
  }, 'dataViews$', _presentationPublishing.apiPublishesDataViews, []);
  const dataViewsSubscription = (0, _rxjs.combineLatest)([controlGroupDataViewsPipe, childDataViewsPipe]).pipe((0, _rxjs.switchMap)(async ([controlGroupDataViews, childDataViews]) => {
    const allDataViews = [...(controlGroupDataViews !== null && controlGroupDataViews !== void 0 ? controlGroupDataViews : []), ...childDataViews].filter(dataView => dataView.isPersisted());
    if (allDataViews.length === 0) {
      try {
        const defaultDataView = await _kibana_services.dataService.dataViews.getDefaultDataView();
        if (defaultDataView) {
          allDataViews.push(defaultDataView);
        }
      } catch (error) {
        // ignore error getting default data view
      }
    }
    return (0, _lodash.uniqBy)(allDataViews, 'id');
  })).subscribe(nextDataViews => {
    dataViews$.next(nextDataViews);
  });
  return {
    api: {
      dataViews$
    },
    cleanup: () => {
      dataViewsSubscription.unsubscribe();
    }
  };
}