"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSessionsMgmtTable = SearchSessionsMgmtTable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _ = require("..");
var _common = require("../../../../../../common");
var _get_columns = require("../../lib/get_columns");
var _app_filter = require("./app_filter");
var _status_filter = require("./status_filter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function SearchSessionsMgmtTable({
  core,
  api,
  timezone,
  config,
  kibanaVersion,
  searchUsageCollector,
  ...props
}) {
  const [tableData, setTableData] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [debouncedIsLoading, setDebouncedIsLoading] = (0, _react.useState)(false);
  const showLatestResultsHandler = (0, _react.useRef)();
  const refreshTimeoutRef = (0, _react.useRef)(null);
  const refreshInterval = (0, _react.useMemo)(() => _moment.default.duration(config.management.refreshInterval).asMilliseconds(), [config.management.refreshInterval]);
  const {
    pageSize,
    sorting,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'searchSessionsMgmt',
    initialSort: {
      field: 'created',
      direction: 'desc'
    }
  });

  // Debounce rendering the state of the Refresh button
  (0, _useDebounce.default)(() => {
    setDebouncedIsLoading(isLoading);
  }, 250, [isLoading]);

  // refresh behavior
  const doRefresh = (0, _react.useCallback)(async () => {
    if (refreshTimeoutRef.current) {
      clearTimeout(refreshTimeoutRef.current);
      refreshTimeoutRef.current = null;
    }
    setIsLoading(true);
    const renderResults = results => {
      setTableData(results);
    };
    showLatestResultsHandler.current = renderResults;
    if (document.visibilityState !== 'hidden') {
      let results = [];
      try {
        results = await api.fetchTableData();
      } catch (e) {} // eslint-disable-line no-empty

      if (showLatestResultsHandler.current === renderResults) {
        renderResults(results);
        setIsLoading(false);
      }
    }
    if (showLatestResultsHandler.current === renderResults && refreshInterval > 0) {
      if (refreshTimeoutRef.current) clearTimeout(refreshTimeoutRef.current);
      refreshTimeoutRef.current = window.setTimeout(doRefresh, refreshInterval);
    }
  }, [api, refreshInterval]);

  // initial data load
  (0, _react.useEffect)(() => {
    doRefresh();
    searchUsageCollector.trackSessionsListLoaded();
    return () => {
      if (refreshTimeoutRef.current) clearTimeout(refreshTimeoutRef.current);
    };
  }, [doRefresh, searchUsageCollector]);
  const onActionComplete = () => {
    doRefresh();
  };

  // table config: search / filters
  const search = {
    box: {
      incremental: true
    },
    filters: [(0, _status_filter.getStatusFilter)(tableData), (0, _app_filter.getAppFilter)(tableData)],
    toolsRight: /*#__PURE__*/_react.default.createElement(_.TableText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "refresh",
      onClick: doRefresh,
      disabled: debouncedIsLoading,
      isLoading: debouncedIsLoading,
      "data-test-subj": "sessionManagementRefreshBtn"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.mgmt.searchSessions.search.tools.refresh",
      defaultMessage: "Refresh"
    })))
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, (0, _extends2.default)({}, props, {
    id: _common.SEARCH_SESSIONS_TABLE_ID,
    "data-test-subj": _common.SEARCH_SESSIONS_TABLE_ID,
    rowProps: searchSession => ({
      'data-test-subj': `searchSessionsRow`,
      'data-test-search-session-id': `id-${searchSession.id}`
    }),
    columns: (0, _get_columns.getColumns)(core, api, config, timezone, onActionComplete, kibanaVersion, searchUsageCollector),
    items: tableData,
    pagination: {
      pageSize
    },
    search: search,
    sorting: sorting,
    onTableChange: onTableChange,
    tableLayout: "auto"
  }));
}