"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsqlDataView = getEsqlDataView;
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getEsqlDataView(query, currentDataView, services) {
  const indexPatternFromQuery = (0, _esqlUtils.getIndexPatternFromESQLQuery)(query.esql);
  const newTimeField = (0, _esqlUtils.getTimeFieldFromESQLQuery)(query.esql);
  if (currentDataView !== null && currentDataView !== void 0 && currentDataView.isPersisted() || indexPatternFromQuery !== (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.getIndexPattern()) ||
  // here the pattern hasn't changed but the time field has
  newTimeField !== (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName) && indexPatternFromQuery === (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.getIndexPattern())) {
    return await (0, _esqlUtils.getESQLAdHocDataview)(query.esql, services.dataViews);
  }
  return currentDataView;
}