"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.User = exports.UUID = exports.SortOrderEnum = exports.SortOrder = exports.ScreenContext = exports.PromptIds = exports.NonEmptyTimestamp = exports.NonEmptyString = exports.BulkCrudActionSummary = exports.BulkActionBase = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Elastic AI Assistant Attributes
 *   version: not applicable
 */

/**
 * A string that does not contain only whitespace characters.
 */

const NonEmptyString = exports.NonEmptyString = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * A string that represents a timestamp in ISO 8601 format and does not contain only whitespace characters.
 */

const NonEmptyTimestamp = exports.NonEmptyTimestamp = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * A universally unique identifier.
 */

const UUID = exports.UUID = _zod.z.string().uuid();

/**
 * Could be any string, not necessarily a UUID.
 */

const User = exports.User = _zod.z.object({
  /**
   * User id.
   */
  id: _zod.z.string().optional(),
  /**
   * User name.
   */
  name: _zod.z.string().optional()
});

/**
 * The order in which results are sorted.
 */

const SortOrder = exports.SortOrder = _zod.z.enum(['asc', 'desc']);
const SortOrderEnum = exports.SortOrderEnum = SortOrder.enum;

/**
 * User screen context.
 */

const ScreenContext = exports.ScreenContext = _zod.z.object({
  /**
   * The local timezone of the user.
   */
  timeZone: _zod.z.string().optional()
});
const BulkCrudActionSummary = exports.BulkCrudActionSummary = _zod.z.object({
  /**
   * The number of failed actions.
   */
  failed: _zod.z.number().int(),
  /**
   * The number of skipped actions.
   */
  skipped: _zod.z.number().int(),
  /**
   * The number of successfully performed actions.
   */
  succeeded: _zod.z.number().int(),
  /**
   * The total number of actions attempted.
   */
  total: _zod.z.number().int()
});
const BulkActionBase = exports.BulkActionBase = _zod.z.object({
  /**
   * Query to filter the bulk action.
   */
  query: _zod.z.string().optional(),
  /**
   * Array of IDs to apply the action to.
   */
  ids: _zod.z.array(_zod.z.string()).min(1).optional()
});

/**
 * IDs for a specific prompt within a group of prompts.
 */

const PromptIds = exports.PromptIds = _zod.z.object({
  /**
   * The unique identifier for a specific prompt.
   */
  promptId: _zod.z.string(),
  /**
   * The unique identifier for a group of prompts.
   */
  promptGroupId: _zod.z.string()
});