"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIncompatibleAntivirusPrompt = getIncompatibleAntivirusPrompt;
var _prompt = require("../../../../prompt");
var _local_prompt_object = require("../../../../prompt/local_prompt_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// We may need to differentiate between insights in the future, keeping the type for now

// We may need to differentiate between insights in the future, keeping the type for now

async function getIncompatibleAntivirusPrompt({
  actionsClient,
  connector,
  connectorId,
  model,
  provider,
  savedObjectsClient
}) {
  const prompts = await (0, _prompt.getPromptsByGroupId)({
    actionsClient,
    connector,
    connectorId,
    model,
    provider,
    savedObjectsClient,
    promptGroupId: _local_prompt_object.promptGroupId.defendInsights.incompatibleAntivirus,
    promptIds: [_prompt.promptDictionary.defendInsightsIncompatibleAntivirusDefault, _prompt.promptDictionary.defendInsightsIncompatibleAntivirusRefine, _prompt.promptDictionary.defendInsightsIncompatibleAntivirusContinue, _prompt.promptDictionary.defendInsightsIncompatibleAntivirusGroup, _prompt.promptDictionary.defendInsightsIncompatibleAntivirusEvents, _prompt.promptDictionary.defendInsightsIncompatibleAntivirusEventsId, _prompt.promptDictionary.defendInsightsIncompatibleAntivirusEventsEndpointId, _prompt.promptDictionary.defendInsightsIncompatibleAntivirusEventsValue]
  });
  const getPromptById = id => {
    var _prompts$find;
    return ((_prompts$find = prompts.find(prompt => prompt.promptId === id)) === null || _prompts$find === void 0 ? void 0 : _prompts$find.prompt) || '';
  };
  return {
    default: getPromptById(_prompt.promptDictionary.defendInsightsIncompatibleAntivirusDefault),
    refine: getPromptById(_prompt.promptDictionary.defendInsightsIncompatibleAntivirusRefine),
    continue: getPromptById(_prompt.promptDictionary.defendInsightsIncompatibleAntivirusContinue),
    group: getPromptById(_prompt.promptDictionary.defendInsightsIncompatibleAntivirusGroup),
    events: getPromptById(_prompt.promptDictionary.defendInsightsIncompatibleAntivirusEvents),
    eventsId: getPromptById(_prompt.promptDictionary.defendInsightsIncompatibleAntivirusEventsId),
    eventsEndpointId: getPromptById(_prompt.promptDictionary.defendInsightsIncompatibleAntivirusEventsEndpointId),
    eventsValue: getPromptById(_prompt.promptDictionary.defendInsightsIncompatibleAntivirusEventsValue)
  };
}