"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EncodedSecurityLabsContentLoader = void 0;
var _aiSecurityLabsContent = require("@kbn/ai-security-labs-content");
var _text = require("langchain/document_loaders/fs/text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EncodedSecurityLabsContentLoader extends _text.TextLoader {
  parse(raw) {
    return Promise.resolve([(0, _aiSecurityLabsContent.decryptSecurityLabsContent)(raw)]);
  }
  async load() {
    if (typeof this.filePathOrBlob === 'string' && !this.filePathOrBlob.endsWith('encoded.md')) {
      return Promise.resolve([]); // Skip files that are not encoded
    }
    return super.load();
  }
}
exports.EncodedSecurityLabsContentLoader = EncodedSecurityLabsContentLoader;