"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorHandler = void 0;
var _esErrors = require("@kbn/es-errors");
var _identify_es_error = require("@kbn/task-manager-plugin/server/lib/identify_es_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isKibanaServerError(error) {
  return typeof error === 'object' && error !== null && 'statusCode' in error && 'message' in error;
}

/**
 * Default Connector routes error handler
 * @param res
 * @param error
 */
const errorHandler = (res, error) => {
  if (isKibanaServerError(error)) {
    const errorCausedBy = (0, _identify_es_error.identifyEsError)(error);
    if ((0, _esErrors.isResponseError)(error) && error.statusCode === 400) {
      var _errorCausedBy$pop;
      return res.badRequest({
        body: {
          message: (_errorCausedBy$pop = errorCausedBy.pop()) !== null && _errorCausedBy$pop !== void 0 ? _errorCausedBy$pop : error.message
        }
      });
    }
    if ((0, _esErrors.isUnauthorizedError)(error)) {
      return res.forbidden({
        body: error
      });
    }
    if ((0, _esErrors.isNotFoundError)(error)) {
      return res.notFound({
        body: error
      });
    }
    return res.customError({
      statusCode: error.statusCode,
      body: error.message
    });
  }
  // Kibana CORE will take care of `500` errors when the handler `throw`'s, including logging the error
  throw error;
};
exports.errorHandler = errorHandler;