"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyOperationDetailView = DependencyOperationDetailView;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _chart_pointer_event_context = require("../../../context/chart_pointer_event/chart_pointer_event_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_dependency_detail_operations_breadcrumb = require("../../../hooks/use_dependency_detail_operations_breadcrumb");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _dependency_metric_charts = require("../../shared/dependency_metric_charts");
var _resetting_height_container = require("../../shared/height_retainer/resetting_height_container");
var _url_helpers = require("../../shared/links/url_helpers");
var _use_waterfall_fetcher = require("../transaction_details/use_waterfall_fetcher");
var _waterfall_with_summary = require("../transaction_details/waterfall_with_summary");
var _dependency_operation_distribution_chart = require("./dependency_operation_distribution_chart");
var _detail_view_header = require("./detail_view_header");
var _maybe_redirect_to_available_span_sample = require("./maybe_redirect_to_available_span_sample");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/dependency_operation_detail_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DependencyOperationDetailView() {
  var _spanFetch$data2, _waterfallFetch$water;
  const router = (0, _use_apm_router.useApmRouter)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    query,
    query: {
      spanName,
      dependencyName,
      sampleRangeFrom,
      sampleRangeTo,
      kuery,
      environment,
      rangeFrom,
      rangeTo,
      spanId,
      waterfallItemId,
      detailTab,
      sortField = '@timestamp',
      sortDirection = 'desc',
      showCriticalPath
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies/operation');
  (0, _use_dependency_detail_operations_breadcrumb.useDependencyDetailOperationsBreadcrumb)({
    title: spanName,
    href: router.link('/dependencies/operation', {
      query
    })
  });
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const queryWithoutSpanName = (0, _lodash.omit)(query, 'spanName');
  const spanFetch = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/dependencies/operations/spans', {
      params: {
        query: {
          dependencyName,
          spanName,
          start,
          end,
          environment,
          kuery,
          sampleRangeFrom,
          sampleRangeTo
        }
      }
    });
  }, [dependencyName, spanName, start, end, environment, kuery, sampleRangeFrom, sampleRangeTo]);
  const samples = (0, _react.useMemo)(() => {
    var _spanFetch$data$spans, _spanFetch$data;
    return (0, _lodash.orderBy)((_spanFetch$data$spans = (_spanFetch$data = spanFetch.data) === null || _spanFetch$data === void 0 ? void 0 : _spanFetch$data.spans) !== null && _spanFetch$data$spans !== void 0 ? _spanFetch$data$spans : [], sortField, sortDirection).map(span => ({
      spanId: span.spanId,
      traceId: span.traceId,
      transactionId: span.transactionId
    })) || [];
  }, [(_spanFetch$data2 = spanFetch.data) === null || _spanFetch$data2 === void 0 ? void 0 : _spanFetch$data2.spans, sortField, sortDirection]);
  const selectedSample = (0, _react.useMemo)(() => {
    return samples.find(sample => sample.spanId === spanId);
  }, [samples, spanId]);
  const waterfallFetch = (0, _use_waterfall_fetcher.useWaterfallFetcher)({
    traceId: selectedSample === null || selectedSample === void 0 ? void 0 : selectedSample.traceId,
    transactionId: selectedSample === null || selectedSample === void 0 ? void 0 : selectedSample.transactionId,
    start,
    end
  });
  const queryRef = (0, _react.useRef)(query);
  queryRef.current = query;
  (0, _react.useEffect)(() => {
    var _queryRef$current$pag, _queryRef$current$pag2;
    (0, _maybe_redirect_to_available_span_sample.maybeRedirectToAvailableSpanSample)({
      history,
      page: (_queryRef$current$pag = queryRef.current.page) !== null && _queryRef$current$pag !== void 0 ? _queryRef$current$pag : 0,
      pageSize: (_queryRef$current$pag2 = queryRef.current.pageSize) !== null && _queryRef$current$pag2 !== void 0 ? _queryRef$current$pag2 : 10,
      replace: _url_helpers.replace,
      samples,
      spanFetchStatus: spanFetch.status,
      spanId
    });
  }, [samples, spanId, history, queryRef, router, spanFetch.status]);
  const isWaterfallLoading = spanFetch.status === _use_fetcher.FETCH_STATUS.NOT_INITIATED || spanFetch.status === _use_fetcher.FETCH_STATUS.LOADING && samples.length === 0 || waterfallFetch.status === _use_fetcher.FETCH_STATUS.LOADING && !waterfallFetch.waterfall.entryWaterfallTransaction;
  const onSampleClick = (0, _react.useCallback)(sample => {
    (0, _url_helpers.push)(history, {
      query: {
        spanId: sample.spanId
      }
    });
  }, [history]);
  const onTabClick = (0, _react.useCallback)(nextDetailTab => {
    (0, _url_helpers.push)(history, {
      query: {
        detailTab: nextDetailTab
      }
    });
  }, [history]);
  const onShowCriticalPathChange = (0, _react.useCallback)(nextShowCriticalPath => {
    (0, _url_helpers.push)(history, {
      query: {
        showCriticalPath: nextShowCriticalPath ? 'true' : 'false'
      }
    });
  }, [history]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_detail_view_header.DetailViewHeader, {
    backLabel: _i18n.i18n.translate('xpack.apm.dependecyOperationDetailView.header.backLinkLabel', {
      defaultMessage: 'All operations'
    }),
    backHref: router.link('/dependencies/operations', {
      query: queryWithoutSpanName
    }),
    title: spanName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_dependency_metric_charts.DependencyMetricCharts, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_dependency_operation_distribution_chart.DependencyOperationDistributionChart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_resetting_height_container.ResettingHeightRetainer, {
    reset: !isWaterfallLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall_with_summary.WaterfallWithSummary, {
    environment: environment,
    waterfallFetchResult: waterfallFetch.waterfall,
    waterfallFetchStatus: waterfallFetch.status,
    traceSamples: samples,
    traceSamplesFetchStatus: spanFetch.status,
    onSampleClick: onSampleClick,
    onTabClick: onTabClick,
    serviceName: (_waterfallFetch$water = waterfallFetch.waterfall.entryWaterfallTransaction) === null || _waterfallFetch$water === void 0 ? void 0 : _waterfallFetch$water.doc.service.name,
    waterfallItemId: waterfallItemId,
    detailTab: detailTab,
    selectedSample: selectedSample || null,
    showCriticalPath: showCriticalPath,
    onShowCriticalPathChange: onShowCriticalPathChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  })))));
}