"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpanMetricColumns = getSpanMetricColumns;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_timeseries_color = require("../charts/helper/get_timeseries_color");
var _list_metric = require("../list_metric");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _formatters = require("../../../../common/utils/formatters");
var _impact_bar = require("../impact_bar");
var _is_finite_number = require("../../../../common/utils/is_finite_number");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/dependencies_table/get_span_metric_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getSpanMetricColumns({
  comparisonFetchStatus,
  shouldShowSparkPlots
}) {
  const isLoading = (0, _use_fetcher.isPending)(comparisonFetchStatus);
  return [{
    field: 'latency',
    name: _i18n.i18n.translate('xpack.apm.dependenciesTable.columnLatency', {
      defaultMessage: 'Latency (avg.)'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      latency,
      currentStats,
      previousStats
    }) => {
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        compact: true,
        color: currentPeriodColor,
        hideSeries: !shouldShowSparkPlots,
        isLoading: isLoading,
        series: currentStats === null || currentStats === void 0 ? void 0 : currentStats.latency,
        comparisonSeries: previousStats === null || previousStats === void 0 ? void 0 : previousStats.latency,
        valueLabel: (0, _formatters.asMillisecondDuration)(latency),
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 11
        }
      });
    },
    sortable: true
  }, {
    field: 'throughput',
    name: _i18n.i18n.translate('xpack.apm.dependenciesTable.columnThroughput', {
      defaultMessage: 'Throughput'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      throughput,
      currentStats,
      previousStats
    }) => {
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        compact: true,
        color: currentPeriodColor,
        hideSeries: !shouldShowSparkPlots,
        isLoading: isLoading,
        series: currentStats === null || currentStats === void 0 ? void 0 : currentStats.throughput,
        comparisonSeries: previousStats === null || previousStats === void 0 ? void 0 : previousStats.throughput,
        valueLabel: (0, _formatters.asTransactionRate)(throughput),
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 11
        }
      });
    },
    sortable: true
  }, {
    field: 'failureRate',
    name: _i18n.i18n.translate('xpack.apm.dependenciesTable.columnErrorRate', {
      defaultMessage: 'Failed transaction rate'
    }),
    nameTooltip: {
      content: _i18n.i18n.translate('xpack.apm.dependenciesTable.columnErrorRateTip', {
        defaultMessage: "The percentage of failed transactions for the selected service. HTTP server transactions with a 4xx status code (client error) aren't considered failures because the caller, not the server, caused the failure."
      })
    },
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      failureRate,
      currentStats,
      previousStats
    }) => {
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        compact: true,
        color: currentPeriodColor,
        hideSeries: !shouldShowSparkPlots,
        isLoading: isLoading,
        series: currentStats === null || currentStats === void 0 ? void 0 : currentStats.failureRate,
        comparisonSeries: previousStats === null || previousStats === void 0 ? void 0 : previousStats.failureRate,
        valueLabel: (0, _formatters.asPercent)(failureRate, 1),
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 11
        }
      });
    },
    sortable: true
  }, {
    field: 'impact',
    name: _i18n.i18n.translate('xpack.apm.dependenciesTable.columnImpact', {
      defaultMessage: 'Impact'
    }),
    nameTooltip: {
      content: _i18n.i18n.translate('xpack.apm.dependenciesTable.columnImpactTip', {
        defaultMessage: 'The most used and slowest endpoints in your service. Calculated by multiplying latency by throughput.'
      })
    },
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      impact,
      previousStats
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "flexEnd",
        gutterSize: "xs",
        direction: "column",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_impact_bar.ImpactBar, {
        value: impact !== null && impact !== void 0 ? impact : 0,
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 15
        }
      })), previousStats && (0, _is_finite_number.isFiniteNumber)(previousStats.impact) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_impact_bar.ImpactBar, {
        value: previousStats.impact,
        size: "s",
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 17
        }
      })));
    },
    sortable: true
  }];
}