"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _shortcut_manager = require("../../lib/shortcut_manager");
var _routes = require("../../routes");
var _flyouts = require("../flyouts");
var _storage = require("../../lib/storage");
var _lib = require("../../../common/lib");
var _kibana_services = require("../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/app/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ShortcutManagerContextWrapper extends _react.default.Component {
  getChildContext() {
    return {
      shortcuts: _shortcut_manager.shortcutManager
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.props.children);
  }
}
(0, _defineProperty2.default)(ShortcutManagerContextWrapper, "childContextTypes", {
  shortcuts: _propTypes.default.object.isRequired
});
const App = ({
  history,
  appUpdater
}) => {
  (0, _react.useEffect)(() => {
    return history.listen(({
      pathname,
      search
    }) => {
      const path = pathname + search;
      appUpdater.next(() => ({
        defaultPath: path
      }));
      (0, _storage.getSessionStorage)().set(`${_lib.SESSIONSTORAGE_LASTPATH}:${_kibana_services.coreServices.http.basePath.get()}`, path);
    });
  });
  return /*#__PURE__*/_react.default.createElement(ShortcutManagerContextWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvas canvasContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_routes.CanvasRouter, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_flyouts.Flyouts, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  })));
};
exports.App = App;