"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DomPreview = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/dom_preview/dom_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class DomPreview extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_container", null);
    (0, _defineProperty2.default)(this, "_content", null);
    (0, _defineProperty2.default)(this, "_observer", null);
    (0, _defineProperty2.default)(this, "_original", null);
    (0, _defineProperty2.default)(this, "_updateTimeout", 0);
    (0, _defineProperty2.default)(this, "update", () => {
      if (!this._content || !this._container) {
        return;
      }
      const currentOriginal = document.querySelector(`#${this.props.elementId}`);
      const originalChanged = currentOriginal !== this._original;
      if (originalChanged) {
        if (this._observer) {
          this._observer.disconnect();
        }
        this._original = currentOriginal;
        if (this._original) {
          const slowUpdate = (0, _lodash.debounce)(this.update, 100);
          this._observer = new MutationObserver(slowUpdate);
          // configuration of the observer
          const config = {
            attributes: true,
            childList: true,
            subtree: true
          };
          // pass in the target node, as well as the observer options
          this._observer.observe(this._original, config);
        } else {
          clearTimeout(this._updateTimeout); // to avoid the assumption that we fully control when `update` is called
          this._updateTimeout = window.setTimeout(this.update, 30);
          return;
        }
      }
      if (!this._original) {
        return;
      }
      const thumb = this._original.cloneNode(true);
      thumb.id += '-thumb';
      const originalStyle = window.getComputedStyle(this._original, null);
      const originalWidth = parseInt(originalStyle.getPropertyValue('width'), 10);
      const originalHeight = parseInt(originalStyle.getPropertyValue('height'), 10);
      let thumbHeight = 0;
      let thumbWidth = 0;
      let scale = 1;
      if (this.props.height) {
        thumbHeight = this.props.height;
        scale = thumbHeight / originalHeight;
        thumbWidth = originalWidth * scale;
      } else if (this.props.width) {
        thumbWidth = this.props.width;
        scale = thumbWidth / originalWidth;
        thumbHeight = originalHeight * scale;
      }
      if (this._content.firstChild) {
        this._content.removeChild(this._content.firstChild);
      }
      this._content.appendChild(thumb);
      this._content.style.cssText = `transform: scale(${scale}); transform-origin: top left;`;
      this._container.style.cssText = `width: ${thumbWidth}px; height: ${thumbHeight}px;`;

      // Copy canvas data
      const originalCanvas = this._original.querySelectorAll('canvas');
      const thumbCanvas = thumb.querySelectorAll('canvas');

      // Cloned canvas elements are blank and need to be explicitly redrawn
      if (originalCanvas.length > 0) {
        Array.from(originalCanvas).map((img, i) => {
          const context = thumbCanvas[i].getContext('2d');
          if (context) {
            context.drawImage(img, 0, 0);
          }
        });
      }
    });
  }
  componentDidMount() {
    this.update();
  }
  componentWillUnmount() {
    clearTimeout(this._updateTimeout);
    if (this._observer) {
      this._observer.disconnect(); // observer not guaranteed to exist
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      ref: container => {
        this._container = container;
      },
      className: "dom-preview",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: content => {
        this._content = content;
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }));
  }
}
exports.DomPreview = DomPreview;
(0, _defineProperty2.default)(DomPreview, "propTypes", {
  elementId: _propTypes.default.string.isRequired,
  height: _propTypes.default.number,
  width: _propTypes.default.number
});