"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContentWrapperCss = exports.ScrollableMarkdown = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _renderer = require("./renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/markdown_editor/scrollable_markdown_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getContentWrapperCss = euiTheme => (0, _react2.css)`
  padding: ${`${euiTheme.size.m} ${euiTheme.size.l}`};
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-box-orient: vertical;
`;
exports.getContentWrapperCss = getContentWrapperCss;
const ScrollableMarkdownRenderer = ({
  content
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: 'eui-xScroll',
    css: getContentWrapperCss(euiTheme),
    "data-test-subj": "scrollable-markdown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_renderer.MarkdownRenderer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, content));
};
ScrollableMarkdownRenderer.displayName = 'ScrollableMarkdownRenderer';
const ScrollableMarkdown = exports.ScrollableMarkdown = /*#__PURE__*/_react.default.memo(ScrollableMarkdownRenderer);