"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../../shared_imports");
var _track_ui_metric = require("../../../services/track_ui_metric");
var _constants = require("../../../constants");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/sections/home/auto_follow_pattern_list/auto_follow_pattern_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const REFRESH_RATE_MS = 30000;
const getQueryParamPattern = ({
  location: {
    search
  }
}) => {
  const {
    pattern
  } = (0, _shared_imports.extractQueryParams)(search);
  return pattern ? decodeURIComponent(pattern) : null;
};
class AutoFollowPatternList extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      lastAutoFollowPatternId: null,
      isDetailPanelOpen: false
    });
  }
  static getDerivedStateFromProps({
    autoFollowPatternId
  }, {
    lastAutoFollowPatternId
  }) {
    if (autoFollowPatternId !== lastAutoFollowPatternId) {
      return {
        lastAutoFollowPatternId: autoFollowPatternId,
        isDetailPanelOpen: !!autoFollowPatternId
      };
    }
    return null;
  }
  componentDidMount() {
    const {
      loadAutoFollowPatterns,
      loadAutoFollowStats,
      selectAutoFollowPattern,
      history
    } = this.props;
    (0, _track_ui_metric.trackUiMetric)(_track_ui_metric.METRIC_TYPE.LOADED, _constants.UIM_AUTO_FOLLOW_PATTERN_LIST_LOAD);
    loadAutoFollowPatterns();
    loadAutoFollowStats();

    // Select the pattern in the URL query params
    selectAutoFollowPattern(getQueryParamPattern(history));

    // Interval to load auto-follow patterns in the background passing "true" to the fetch method
    this.interval = setInterval(() => loadAutoFollowPatterns(true), REFRESH_RATE_MS);
  }
  componentDidUpdate(prevProps, prevState) {
    const {
      history,
      loadAutoFollowStats
    } = this.props;
    const {
      lastAutoFollowPatternId
    } = this.state;

    /**
     * Each time our state is updated (through getDerivedStateFromProps())
     * we persist the auto-follow pattern id to query params for deep linking
     */
    if (lastAutoFollowPatternId !== prevState.lastAutoFollowPatternId) {
      if (!lastAutoFollowPatternId) {
        history.replace({
          search: ''
        });
      } else {
        history.replace({
          search: `?pattern=${encodeURIComponent(lastAutoFollowPatternId)}`
        });
        loadAutoFollowStats();
      }
    }
  }
  componentWillUnmount() {
    clearInterval(this.interval);
  }
  renderEmpty() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "managementApp",
      "data-test-subj": "emptyPrompt",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternList.emptyPromptTitle",
        defaultMessage: "Create your first auto-follow pattern",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternList.emptyPromptDescription",
        defaultMessage: "Use an auto-follow pattern to automatically replicate indices from a remote cluster.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 13
        }
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(this.props.history, `/auto_follow_patterns/add`), {
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "createAutoFollowPatternButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.addAutoFollowPatternButtonLabel",
        defaultMessage: "Create auto-follow pattern",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 13
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    });
  }
  renderList() {
    const {
      selectAutoFollowPattern,
      autoFollowPatterns
    } = this.props;
    const {
      isDetailPanelOpen
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternList.autoFollowPatternsDescription",
      defaultMessage: "An auto-follow pattern replicates leader indices from a remote cluster and copies them to follower indices on the local cluster.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternTable, {
      autoFollowPatterns: autoFollowPatterns,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 9
      }
    }), isDetailPanelOpen && /*#__PURE__*/_react.default.createElement(_components.DetailPanel, {
      closeDetailPanel: () => selectAutoFollowPattern(null),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 11
      }
    }));
  }
  render() {
    const {
      autoFollowPatterns,
      apiError,
      apiStatus,
      isAuthorized
    } = this.props;
    const isEmpty = apiStatus === _constants.API_STATUS.IDLE && !autoFollowPatterns.length;
    if (!isAuthorized) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternList.permissionErrorTitle",
          defaultMessage: "Permission error",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 168,
            columnNumber: 13
          }
        }),
        error: {
          error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternList.noPermissionText",
            defaultMessage: "You do not have permission to view or add auto-follow patterns.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 175,
              columnNumber: 15
            }
          })
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 9
        }
      });
    }
    if (apiError) {
      const title = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.loadingErrorTitle', {
        defaultMessage: 'Error loading auto-follow patterns'
      });
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
        title: title,
        error: apiError.body,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 14
        }
      });
    }
    if (isEmpty) {
      return this.renderEmpty();
    }
    if (apiStatus === _constants.API_STATUS.LOADING) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternList.loadingTitle",
        defaultMessage: "Loading auto-follow patterns...",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 11
        }
      }));
    }
    return this.renderList();
  }
}
exports.AutoFollowPatternList = AutoFollowPatternList;
(0, _defineProperty2.default)(AutoFollowPatternList, "propTypes", {
  loadAutoFollowPatterns: _propTypes.default.func,
  selectAutoFollowPattern: _propTypes.default.func,
  loadAutoFollowStats: _propTypes.default.func,
  autoFollowPatterns: _propTypes.default.array,
  apiStatus: _propTypes.default.string,
  apiError: _propTypes.default.object
});