"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardListingEmptyPrompt = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _dashboard_backup_service = require("../services/dashboard_backup_service");
var _kibana_services = require("../services/kibana_services");
var _get_dashboard_capabilities = require("../utils/get_dashboard_capabilities");
var _dashboard_listing_strings = require("./_dashboard_listing_strings");
var _confirm_overlays = require("./confirm_overlays");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/dashboard/public/dashboard_listing/dashboard_listing_empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardListingEmptyPrompt = ({
  useSessionStorageIntegration,
  setUnsavedDashboardIds,
  unsavedDashboardIds,
  goToDashboard,
  createItem,
  disableCreateDashboardButton
}) => {
  const isEditingFirstDashboard = (0, _react.useMemo)(() => useSessionStorageIntegration && unsavedDashboardIds.length === 1, [unsavedDashboardIds.length, useSessionStorageIntegration]);
  const getEmptyAction = (0, _react.useCallback)(() => {
    if (!isEditingFirstDashboard) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: createItem,
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "newItemButton",
        disabled: disableCreateDashboardButton,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 9
        }
      }, _dashboard_listing_strings.noItemsStrings.getCreateNewDashboardText());
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "danger",
      onClick: () => (0, _confirm_overlays.confirmDiscardUnsavedChanges)(() => {
        const dashboardBackupService = (0, _dashboard_backup_service.getDashboardBackupService)();
        dashboardBackupService.clearState(_dashboard_backup_service.DASHBOARD_PANELS_UNSAVED_ID);
        setUnsavedDashboardIds(dashboardBackupService.getDashboardIdsWithUnsavedChanges());
      }),
      "data-test-subj": "discardDashboardPromptButton",
      "aria-label": _dashboard_listing_strings.dashboardUnsavedListingStrings.getDiscardAriaLabel((0, _dashboard_listing_strings.getNewDashboardTitle)()),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, _dashboard_listing_strings.dashboardUnsavedListingStrings.getDiscardTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "pencil",
      color: "primary",
      "data-test-subj": "newItemButton",
      onClick: () => goToDashboard(),
      "aria-label": _dashboard_listing_strings.dashboardUnsavedListingStrings.getEditAriaLabel((0, _dashboard_listing_strings.getNewDashboardTitle)()),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, _dashboard_listing_strings.dashboardUnsavedListingStrings.getEditTitle())));
  }, [isEditingFirstDashboard, createItem, disableCreateDashboardButton, goToDashboard, setUnsavedDashboardIds]);
  if (!(0, _get_dashboard_capabilities.getDashboardCapabilities)().showWriteControls) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "glasses",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        id: "dashboardListingHeading",
        "data-test-subj": "emptyListPrompt",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 11
        }
      }, _dashboard_listing_strings.noItemsStrings.getReadonlyTitle()),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 15
        }
      }, _dashboard_listing_strings.noItemsStrings.getReadonlyBody()),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "dashboardApp",
    title: /*#__PURE__*/_react.default.createElement("h1", {
      id: "dashboardListingHeading",
      "data-test-subj": "emptyListPrompt",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }, isEditingFirstDashboard ? _dashboard_listing_strings.noItemsStrings.getReadEditInProgressTitle() : _dashboard_listing_strings.noItemsStrings.getReadEditTitle()),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    }, _dashboard_listing_strings.noItemsStrings.getReadEditDashboardDescription()), !isEditingFirstDashboard && /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.listing.createNewDashboard.newToKibanaDescription",
      defaultMessage: "New to Kibana? {sampleDataInstallLink} to take a test drive.",
      values: {
        sampleDataInstallLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => _kibana_services.coreServices.application.navigateToApp('home', {
            path: '#/tutorial_directory/sampleData'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 21
          }
        }, _dashboard_listing_strings.noItemsStrings.getSampleDataLinkText())
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 15
      }
    }))),
    actions: getEmptyAction(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  });
};
exports.DashboardListingEmptyPrompt = DashboardListingEmptyPrompt;