"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/data_view_editor/public/components/preview_panel/status_message/status_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const NoMatchStatusMessage = allIndicesLength => /*#__PURE__*/_react.default.createElement("span", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.status.notMatchLabel.notMatchDetail",
  defaultMessage: "The index pattern you entered doesn't match any data streams, indices, or index aliases. You can match {strongIndices}.",
  values: {
    strongIndices: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternEditor.status.notMatchLabel.allIndicesLabel",
      defaultMessage: "{indicesLength, plural, one {# source} other {# sources} }",
      values: {
        indicesLength: allIndicesLength
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 13
      }
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 5
  }
}));
const NoMatchNoIndicesStatusMessage = () => /*#__PURE__*/_react.default.createElement("span", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.status.notMatchLabel.notMatchNoIndicesDetail",
  defaultMessage: "The index pattern you entered doesn't match any data streams, indices, or index aliases.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 5
  }
}));
const StatusMessage = ({
  matchedIndices: {
    allIndices = [],
    exactMatchedIndices = [],
    partialMatchedIndices = []
  },
  isIncludingSystemIndices,
  query,
  showSystemIndices
}) => {
  let statusIcon;
  let statusMessage;
  let statusColor;
  const allIndicesLength = allIndices.length;
  if (query.length === 0) {
    statusIcon = undefined;
    statusColor = 'primary';
    if (allIndicesLength >= 1) {
      statusMessage = /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternEditor.status.matchAnyLabel.matchAnyDetail",
        defaultMessage: "Your index pattern can match {sourceCount, plural, one {# source} other {# sources} }.",
        values: {
          sourceCount: allIndicesLength
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 11
        }
      }));
    } else if (!isIncludingSystemIndices && showSystemIndices) {
      statusMessage = /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternEditor.status.noSystemIndicesWithPromptLabel",
        defaultMessage: "No data streams, indices, or index aliases match your index pattern.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 11
        }
      }));
    } else {
      statusMessage = /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternEditor.status.noSystemIndicesLabel",
        defaultMessage: "No data streams, indices, or index aliases match your index pattern.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 11
        }
      }));
    }
  } else if (exactMatchedIndices.length) {
    statusIcon = 'check';
    statusColor = 'success';
    statusMessage = /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternEditor.status.successLabel.successDetail",
      defaultMessage: "Your index pattern matches {sourceCount} {sourceCount, plural, one {source} other {sources} }.",
      values: {
        sourceCount: exactMatchedIndices.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }));
  } else if (partialMatchedIndices.length) {
    statusIcon = undefined;
    statusColor = 'primary';
    statusMessage = /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternEditor.status.partialMatchLabel.partialMatchDetail",
      defaultMessage: "Your index pattern doesn't match any data streams, indices, or index aliases, but {strongIndices} {matchedIndicesLength, plural, one {is} other {are} } similar.",
      values: {
        matchedIndicesLength: partialMatchedIndices.length,
        strongIndices: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "indexPatternEditor.status.partialMatchLabel.strongIndicesLabel",
          defaultMessage: "{matchedIndicesLength, plural, one {source} other {# sources} }",
          values: {
            matchedIndicesLength: partialMatchedIndices.length
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 17
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 9
      }
    }));
  } else {
    statusIcon = undefined;
    statusColor = 'warning';
    statusMessage = allIndicesLength ? NoMatchStatusMessage(allIndicesLength) : NoMatchNoIndicesStatusMessage();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: statusColor,
    "data-test-subj": "createIndexPatternStatusMessage",
    iconType: statusIcon,
    title: statusMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  });
};
exports.StatusMessage = StatusMessage;