"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDataVisualizerESQL = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _mlUrlState = require("@kbn/ml-url-state");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _public = require("@kbn/esql/public");
var _eui = require("@elastic/eui");
var _esqlUtils = require("@kbn/esql-utils");
var _get_data_view_by_index_pattern = require("../../search_strategy/requests/get_data_view_by_index_pattern");
var _index_data_visualizer_viewer = require("../../constants/index_data_visualizer_viewer");
var _kibana_context = require("../../../kibana_context");
var _document_count_content = require("../../../common/components/document_count_content");
var _stats_table = require("../../../common/components/stats_table");
var _field_count_panel = require("../../../common/components/field_count_panel");
var _limit_size = require("../search_panel/esql/limit_size");
var _use_data_visualizer_esql_data = require("../../hooks/esql/use_data_visualizer_esql_data");
var _esql_utils = require("../../search_strategy/requests/esql_utils");
var _field_stats_component_type = require("../../constants/field_stats_component_type");
var _get_reason_fieldstats_unavailable_for_esql_query = require("../../utils/get_reason_fieldstats_unavailable_for_esql_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/components/index_data_visualizer_view/index_data_visualizer_esql.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable react-hooks/exhaustive-deps */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_ESQL_QUERY = {
  esql: ''
};
const IndexDataVisualizerESQL = dataVisualizerProps => {
  var _dataVisualizerListSt;
  const {
    services
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    data
  } = services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  // Query that has been typed, but has not submitted with cmd + enter
  const [localQuery, setLocalQuery] = (0, _react2.useState)(DEFAULT_ESQL_QUERY);
  const [query, setQuery] = (0, _react2.useState)(DEFAULT_ESQL_QUERY);
  const [currentDataView, setCurrentDataView] = (0, _react2.useState)();
  const unsupportedReasonForQuery = (0, _get_reason_fieldstats_unavailable_for_esql_query.getReasonIfFieldStatsUnavailableForQuery)(localQuery);
  const toggleShowEmptyFields = () => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      showEmptyFields: !dataVisualizerListState.showEmptyFields
    });
  };
  const updateLimitSize = newLimitSize => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      limitSize: newLimitSize
    });
  };
  const restorableDefaults = (0, _react2.useMemo)(() => (0, _use_data_visualizer_esql_data.getDefaultESQLDataVisualizerListState)({}),
  // We just need to load the saved preference when the page is first loaded

  []);
  const [dataVisualizerListState, setDataVisualizerListState] = (0, _mlUrlState.usePageUrlState)(_index_data_visualizer_viewer.DATA_VISUALIZER_INDEX_VIEWER, restorableDefaults);
  const updateDataView = dv => {
    if (dv.id !== (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.id)) {
      setCurrentDataView(dv);
    }
  };
  const indexPattern = (0, _react2.useMemo)(() => {
    let indexPatternFromQuery = '';
    if ((0, _esql_utils.isESQLQuery)(query)) {
      indexPatternFromQuery = (0, _esqlUtils.getIndexPatternFromESQLQuery)(query.esql);
    }
    // we should find a better way to work with ESQL queries which dont need a dataview
    if (indexPatternFromQuery === '') {
      return undefined;
    }
    return indexPatternFromQuery;
  }, [query === null || query === void 0 ? void 0 : query.esql]);
  (0, _react2.useEffect)(function updateAdhocDataViewFromQuery() {
    let unmounted = false;
    const update = async () => {
      if (!indexPattern) return;
      const dv = await (0, _get_data_view_by_index_pattern.getOrCreateDataViewByIndexPattern)(data.dataViews, query.esql, currentDataView);
      if (dv) {
        updateDataView(dv);
      }
    };
    if (!unmounted) {
      update();
    }
    return () => {
      unmounted = true;
    };
  }, [indexPattern, data.dataViews, currentDataView]);
  const input = (0, _react2.useMemo)(() => {
    return {
      dataView: currentDataView,
      query,
      savedSearch: undefined,
      sessionId: undefined,
      visibleFieldNames: undefined,
      allowEditDataView: true,
      id: _field_stats_component_type.FieldStatsComponentType.EsqlDataVisualizer,
      indexPattern,
      esql: true
    };
  }, [currentDataView, query === null || query === void 0 ? void 0 : query.esql]);
  const dvPageHeader = (0, _react.css)({
    [(0, _eui.useEuiBreakpoint)(['xs', 's', 'm', 'l'])]: {
      flexDirection: 'column',
      alignItems: 'flex-start'
    }
  });
  const isWithinLargeBreakpoint = (0, _eui.useIsWithinMaxBreakpoint)('l');
  const {
    totalCount,
    progress: combinedProgress,
    queryHistoryStatus,
    overallStatsProgress,
    configs,
    documentCountStats,
    metricsStats,
    timefilter,
    getItemIdToExpandedRowMap,
    resetData,
    limitSize,
    showEmptyFields,
    fieldsCountStats
  } = (0, _use_data_visualizer_esql_data.useESQLDataVisualizerData)(input, dataVisualizerListState);
  const hasValidTimeField = (0, _react2.useMemo)(() => (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName) !== undefined, [currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName]);
  const queryNeedsUpdate = (0, _react2.useMemo)(() => localQuery.esql !== query.esql ? true : undefined, [localQuery.esql, query.esql]);
  const handleRefresh = (0, _react2.useCallback)(() => {
    // The page is already autoamtically updating when time range is changed
    // via the url state
    // so we just need to force update if the query is outdated
    if (queryNeedsUpdate) {
      setQuery(localQuery);
    }
  }, [queryNeedsUpdate, localQuery.esql]);
  const onTextLangQueryChange = (0, _react2.useCallback)(q => {
    if ((0, _esql_utils.isESQLQuery)(q)) {
      setLocalQuery(q);
    }
  }, []);
  const onTextLangQuerySubmit = (0, _react2.useCallback)(async q => {
    if ((0, _esql_utils.isESQLQuery)(q)) {
      const isUnsupported = (0, _get_reason_fieldstats_unavailable_for_esql_query.getReasonIfFieldStatsUnavailableForQuery)(q) !== undefined;
      if (!isUnsupported) {
        resetData();
        setQuery(q);
      }
    }
  }, [resetData]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    restrictWidth: false,
    bottomBorder: false,
    grow: false,
    "data-test-subj": "dataVisualizerIndexPage",
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate.Header, {
    "data-test-subj": "dataVisualizerPageHeader",
    css: dvPageHeader,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "dataViewTitleHeader",
    direction: "row",
    alignItems: "center",
    css: {
      padding: 0,
      marginRight: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, unsupportedReasonForQuery ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: "warning",
    color: "warning",
    title: unsupportedReasonForQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 17
    }
  })) : null), isWithinLargeBreakpoint ? /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 38
    }
  }) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "s",
    "data-test-subj": "dataVisualizerTimeRangeSelectorSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  }, hasValidTimeField && currentDataView ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_mlDatePicker.FullTimeRangeSelector, {
    frozenDataPreference: 'exclude-frozen',
    setFrozenDataPreference: () => {},
    dataView: currentDataView,
    query: undefined,
    disabled: false,
    timefilter: timefilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 17
    }
  })) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_mlDatePicker.DatePickerWrapper, {
    isAutoRefreshOnly: !hasValidTimeField,
    showRefresh: !hasValidTimeField,
    width: "full",
    needsUpdate: queryNeedsUpdate,
    onRefresh: handleRefresh,
    isDisabled: unsupportedReasonForQuery !== undefined,
    tooltipMessage: unsupportedReasonForQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "DataVisualizerESQLEditor",
    css: (0, _react.css)({
      borderTop: euiTheme.border.thin,
      borderLeft: euiTheme.border.thin,
      borderRight: euiTheme.border.thin
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_public.ESQLLangEditor, {
    query: localQuery,
    onTextLangQueryChange: onTextLangQueryChange,
    onTextLangQuerySubmit: onTextLangQuerySubmit,
    detectedTimestamp: currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName,
    hideRunQueryText: false,
    isLoading: queryHistoryStatus !== null && queryHistoryStatus !== void 0 ? queryHistoryStatus : false,
    displayDocumentationAsFlyout: true,
    disableSubmitAction: unsupportedReasonForQuery !== undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: isWithinLargeBreakpoint ? 'column' : 'row',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 13
    }
  }, totalCount !== undefined && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_document_count_content.DocumentCountContent, {
    documentCountStats: documentCountStats,
    totalCount: totalCount,
    samplingProbability: 1,
    loading: false,
    showSettings: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_field_count_panel.FieldCountPanel, {
    showEmptyFields: showEmptyFields,
    toggleShowEmptyFields: toggleShowEmptyFields,
    fieldsCountStats: fieldsCountStats,
    metricsStats: metricsStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react2.default.createElement(_limit_size.ESQLDefaultLimitSizeSelect, {
    limitSize: limitSize,
    onChangeLimitSize: updateLimitSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiProgress, {
    value: combinedProgress,
    max: 100,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement(_stats_table.DataVisualizerTable, {
    isEsql: true,
    items: configs,
    pageState: dataVisualizerListState,
    updatePageState: setDataVisualizerListState,
    getItemIdToExpandedRowMap: getItemIdToExpandedRowMap,
    loading: overallStatsProgress.isRunning,
    overallStatsRunning: overallStatsProgress.isRunning,
    showPreviewByDefault: (_dataVisualizerListSt = dataVisualizerListState.showDistributions) !== null && _dataVisualizerListSt !== void 0 ? _dataVisualizerListSt : true,
    onChange: setDataVisualizerListState,
    totalCount: totalCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 15
    }
  }))))));
};
exports.IndexDataVisualizerESQL = IndexDataVisualizerESQL;