"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NamespacesSelector = NamespacesSelector;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/filters/namespaces_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const namespacesSelectorLabel = _i18n.i18n.translate('xpack.datasetQuality.namespacesSelectorLabel', {
  defaultMessage: 'Namespaces'
});
const namespacesSelectorLoading = _i18n.i18n.translate('xpack.datasetQuality.namespacesSelectorLoading', {
  defaultMessage: 'Loading namespaces'
});
const namespacesSelectorSearchPlaceholder = _i18n.i18n.translate('xpack.datasetQuality.namespacesSelectorSearchPlaceholder', {
  defaultMessage: 'Filter namespaces'
});
const namespacesSelectorNoneAvailable = _i18n.i18n.translate('xpack.datasetQuality.namespacesSelectorNoneAvailable', {
  defaultMessage: 'No namespaces available'
});
const namespacesSelectorNoneMatching = _i18n.i18n.translate('xpack.datasetQuality.namespacesSelectorNoneMatching', {
  defaultMessage: 'No namespaces found'
});
function NamespacesSelector({
  isLoading,
  namespaces,
  onNamespacesChange
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const renderOption = namespace => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 54
    }
  }, namespace.label);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "datasetQualityNamespacesSelectableButton",
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: namespaces.length,
    hasActiveFilters: !!namespaces.find(item => item.checked === 'on'),
    numActiveFilters: namespaces.filter(item => item.checked === 'on').length,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, namespacesSelectorLabel);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "datasetQualityNamespacesSelectable",
    searchable: true,
    searchProps: {
      placeholder: namespacesSelectorSearchPlaceholder,
      compressed: true
    },
    "aria-label": namespacesSelectorLabel,
    options: namespaces,
    onChange: onNamespacesChange,
    isLoading: isLoading,
    loadingMessage: namespacesSelectorLoading,
    emptyMessage: namespacesSelectorNoneAvailable,
    noMatchesMessage: namespacesSelectorNoneMatching,
    renderOption: option => renderOption(option),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, search), list)));
}