"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onResize = exports.DiscoverDocuments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _cellActions = require("@kbn/cell-actions");
var _searchResponseWarnings = require("@kbn/search-response-warnings");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _discoverUtils = require("@kbn/discover-utils");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _unifiedFieldList = require("@kbn/unified-field-list");
var _discover_grid = require("../../../../components/discover_grid");
var _constants = require("../../../../../common/constants");
var _discover_app_state_container = require("../../state_management/discover_app_state_container");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _types = require("../../../types");
var _use_data_state = require("../../hooks/use_data_state");
var _get_allowed_sample_size = require("../../../../utils/get_allowed_sample_size");
var _discover_grid_flyout = require("../../../../components/discover_grid_flyout");
var _use_fetch_more_records = require("./use_fetch_more_records");
var _selected_vs_available_callout = require("./selected_vs_available_callout");
var _customizations = require("../../../../customizations");
var _on_resize_grid_column = require("../../../../utils/on_resize_grid_column");
var _grid_customisations = require("../../hooks/grid_customisations");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _context_awareness = require("../../../../context_awareness");
var _redux = require("../../state_management/redux");
var _scoped_services_provider = require("../../../../components/scoped_services_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/application/main/components/layout/discover_documents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DiscoverGridMemoized = /*#__PURE__*/_react.default.memo(_discover_grid.DiscoverGrid);

// export needs for testing
const onResize = (colSettings, stateContainer) => {
  const state = stateContainer.appState.getState();
  const newGrid = (0, _on_resize_grid_column.onResizeGridColumn)(colSettings, state.grid);
  stateContainer.appState.update({
    grid: newGrid
  });
};
exports.onResize = onResize;
function DiscoverDocumentsComponent({
  viewModeToggle,
  dataView,
  onAddFilter,
  stateContainer,
  onFieldEdited
}) {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    scopedEBTManager
  } = (0, _scoped_services_provider.useScopedServices)();
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const documents$ = stateContainer.dataState.data$.documents$;
  const persistedDiscoverSession = (0, _redux.useInternalStateSelector)(state => state.persistedDiscoverSession);
  const {
    dataViews,
    capabilities,
    uiSettings,
    uiActions,
    fieldsMetadata
  } = services;
  const requestParams = (0, _redux.useCurrentTabSelector)(state => state.dataRequestParams);
  const [dataSource, query, sort, rowHeight, headerRowHeight, rowsPerPage, grid, columns, sampleSizeState, density] = (0, _discover_app_state_container.useAppStateSelector)(state => {
    return [state.dataSource, state.query, state.sort, state.rowHeight, state.headerRowHeight, state.rowsPerPage, state.grid, state.columns, state.sampleSize, state.density];
  });
  const expandedDoc = (0, _redux.useInternalStateSelector)(state => state.expandedDoc);
  const initialDocViewerTabId = (0, _redux.useInternalStateSelector)(state => state.initialDocViewerTabId);
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const documentState = (0, _use_data_state.useDataState)(documents$);
  const isDataLoading = documentState.fetchStatus === _types.FetchStatus.LOADING || documentState.fetchStatus === _types.FetchStatus.PARTIAL;

  // This is needed to prevent EuiDataGrid pushing onSort because the data view has been switched.
  // It's just necessary for non ES|QL requests since they don't have a partial result state, that's
  // considered as loading state in the Component.
  // 1. When switching the data view, the sorting in the URL is reset to the default sorting of the selected data view.
  // 2. The new sort param is already available in this component and propagated to the EuiDataGrid.
  // 3. currentColumns are still referring to the old state
  // 4. since the new sort by field isn't available in currentColumns EuiDataGrid is emitting a 'onSort', which is unsorting the grid
  // 5. this is propagated to Discover's URL and causes an unwanted change of state to an unsorted state
  // This solution switches to the loading state in this component when the URL index doesn't match the dataView.id
  const isDataViewLoading = (0, _redux.useCurrentTabSelector)(state => state.isDataViewLoading) && !isEsqlMode;
  const isEmptyDataResult = isEsqlMode || !documentState.result || documentState.result.length === 0;
  const rows = (0, _react.useMemo)(() => documentState.result || [], [documentState.result]);
  const {
    isMoreDataLoading,
    totalHits,
    onFetchMoreRecords
  } = (0, _use_fetch_more_records.useFetchMoreRecords)({
    stateContainer
  });
  const setAppState = (0, _react.useCallback)(({
    settings,
    ...rest
  }) => {
    stateContainer.appState.update({
      ...rest,
      grid: settings
    });
  }, [stateContainer]);
  const {
    columns: currentColumns,
    onAddColumn,
    onRemoveColumn,
    onSetColumns
  } = (0, _unifiedDataTable.useColumns)({
    capabilities,
    defaultOrder: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    dataView,
    dataViews,
    setAppState,
    columns,
    sort,
    settings: grid
  });
  const onAddColumnWithTracking = (0, _react.useCallback)(columnName => {
    onAddColumn(columnName);
    void scopedEBTManager.trackDataTableSelection({
      fieldName: columnName,
      fieldsMetadata
    });
  }, [onAddColumn, scopedEBTManager, fieldsMetadata]);
  const onRemoveColumnWithTracking = (0, _react.useCallback)(columnName => {
    onRemoveColumn(columnName);
    void scopedEBTManager.trackDataTableRemoval({
      fieldName: columnName,
      fieldsMetadata
    });
  }, [onRemoveColumn, scopedEBTManager, fieldsMetadata]);
  const docViewerRef = (0, _react.useRef)(null);
  const setExpandedDoc = (0, _react.useCallback)((doc, options) => {
    dispatch(_redux.internalStateActions.setExpandedDoc({
      expandedDoc: doc,
      initialDocViewerTabId: options === null || options === void 0 ? void 0 : options.initialTabId
    }));
    if (options !== null && options !== void 0 && options.initialTabId) {
      var _docViewerRef$current;
      (_docViewerRef$current = docViewerRef.current) === null || _docViewerRef$current === void 0 ? void 0 : _docViewerRef$current.setSelectedTabId(options.initialTabId);
    }
  }, [dispatch]);
  const onResizeDataGrid = (0, _react.useCallback)(colSettings => onResize(colSettings, stateContainer), [stateContainer]);
  const onUpdateRowsPerPage = (0, _react.useCallback)(nextRowsPerPage => {
    stateContainer.appState.update({
      rowsPerPage: nextRowsPerPage
    });
  }, [stateContainer]);
  const onUpdateSampleSize = (0, _react.useCallback)(newSampleSize => {
    stateContainer.appState.update({
      sampleSize: newSampleSize
    });
  }, [stateContainer]);
  const onSort = (0, _react.useCallback)(nextSort => {
    stateContainer.appState.update({
      sort: nextSort
    });
  }, [stateContainer]);
  const onUpdateRowHeight = (0, _react.useCallback)(newRowHeight => {
    stateContainer.appState.update({
      rowHeight: newRowHeight
    });
  }, [stateContainer]);
  const onUpdateHeaderRowHeight = (0, _react.useCallback)(newHeaderRowHeight => {
    stateContainer.appState.update({
      headerRowHeight: newHeaderRowHeight
    });
  }, [stateContainer]);
  const onUpdateDensity = (0, _react.useCallback)(newDensity => {
    stateContainer.appState.update({
      density: newDensity
    });
  }, [stateContainer]);

  // should be aligned with embeddable `showTimeCol` prop
  const showTimeCol = (0, _react.useMemo)(() => !uiSettings.get(_discoverUtils.DOC_HIDE_TIME_COLUMN_SETTING, false), [uiSettings]);
  const columnsMeta = (0, _react.useMemo)(() => documentState.esqlQueryColumns ? (0, _unifiedDataTable.getTextBasedColumnsMeta)(documentState.esqlQueryColumns) : undefined, [documentState.esqlQueryColumns]);
  const {
    filters
  } = (0, _unifiedFieldList.useQuerySubscriber)({
    data: services.data
  });
  const cellActionsMetadata = (0, _context_awareness.useAdditionalCellActions)({
    dataSource,
    dataView,
    query,
    filters,
    timeRange: requestParams.timeRangeAbsolute
  });
  const renderDocumentView = (0, _react.useCallback)((hit, displayedRows, displayedColumns, customColumnsMeta) => /*#__PURE__*/_react.default.createElement(_discover_grid_flyout.DiscoverGridFlyout, {
    dataView: dataView,
    hit: hit,
    hits: displayedRows
    // if default columns are used, dont make them part of the URL - the context state handling will take care to restore them
    ,
    columns: displayedColumns,
    columnsMeta: customColumnsMeta,
    savedSearchId: persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.id,
    onFilter: onAddFilter,
    onRemoveColumn: onRemoveColumnWithTracking,
    onAddColumn: onAddColumnWithTracking,
    onClose: () => setExpandedDoc(undefined),
    setExpandedDoc: setExpandedDoc,
    query: query,
    initialTabId: initialDocViewerTabId,
    docViewerRef: docViewerRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 7
    }
  }), [dataView, persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.id, onAddFilter, onRemoveColumnWithTracking, onAddColumnWithTracking, setExpandedDoc, query, initialDocViewerTabId]);
  const dataGridUiState = (0, _redux.useCurrentTabSelector)(state => state.uiState.dataGrid);
  const setDataGridUiState = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.setDataGridUiState);
  const onInitialStateChange = (0, _react.useCallback)(newDataGridUiState => {
    dispatch(setDataGridUiState({
      dataGridUiState: newDataGridUiState
    }));
  }, [dispatch, setDataGridUiState]);
  const configRowHeight = uiSettings.get(_discoverUtils.ROW_HEIGHT_OPTION);
  const cellRendererDensity = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = density !== null && density !== void 0 ? density : dataGridUiState === null || dataGridUiState === void 0 ? void 0 : dataGridUiState.density) !== null && _ref !== void 0 ? _ref : (0, _unifiedDataTable.getDataGridDensity)(services.storage, 'discover');
  }, [density, dataGridUiState, services.storage]);
  const cellRendererRowHeight = (0, _react.useMemo)(() => (0, _unifiedDataTable.getRowHeight)({
    storage: services.storage,
    consumer: 'discover',
    rowHeightState: rowHeight !== null && rowHeight !== void 0 ? rowHeight : dataGridUiState === null || dataGridUiState === void 0 ? void 0 : dataGridUiState.rowHeight,
    configRowHeight
  }), [rowHeight, dataGridUiState, services.storage, configRowHeight]);
  const cellRendererParams = (0, _react.useMemo)(() => ({
    actions: {
      addFilter: onAddFilter
    },
    dataView,
    density: cellRendererDensity,
    rowHeight: cellRendererRowHeight
  }), [onAddFilter, dataView, cellRendererDensity, cellRendererRowHeight]);
  const {
    rowAdditionalLeadingControls
  } = (0, _customizations.useDiscoverCustomization)('data_table') || {};
  const {
    customCellRenderer
  } = (0, _grid_customisations.useContextualGridCustomisations)(cellRendererParams) || {};
  const getCellRenderersAccessor = (0, _context_awareness.useProfileAccessor)('getCellRenderers');
  const cellRenderers = (0, _react.useMemo)(() => {
    const getCellRenderers = getCellRenderersAccessor(() => customCellRenderer !== null && customCellRenderer !== void 0 ? customCellRenderer : {});
    return getCellRenderers(cellRendererParams);
  }, [cellRendererParams, customCellRenderer, getCellRenderersAccessor]);
  const documents = (0, _useObservable.default)(stateContainer.dataState.data$.documents$);
  const callouts = (0, _react.useMemo)(() => {
    var _documentState$interc;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_selected_vs_available_callout.SelectedVSAvailableCallout, {
      esqlQueryColumns: documents === null || documents === void 0 ? void 0 : documents.esqlQueryColumns
      // If `_source` is in the columns, we should exclude it from the callout
      ,
      selectedColumns: currentColumns.filter(col => col !== '_source'),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 384,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_searchResponseWarnings.SearchResponseWarningsCallout, {
      warnings: (_documentState$interc = documentState.interceptedWarnings) !== null && _documentState$interc !== void 0 ? _documentState$interc : [],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 9
      }
    }));
  }, [currentColumns, documents === null || documents === void 0 ? void 0 : documents.esqlQueryColumns, documentState.interceptedWarnings]);
  const loadingIndicator = (0, _react.useMemo)(() => isDataLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "discoverDataGridUpdating",
    size: "xs",
    color: "accent",
    position: "absolute",
    css: styles.progress,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 9
    }
  }) : null, [isDataLoading, styles.progress]);
  const renderCustomToolbarWithElements = (0, _react.useMemo)(() => (0, _unifiedDataTable.getRenderCustomToolbarWithElements)({
    leftSide: viewModeToggle,
    bottomSection: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, callouts, loadingIndicator)
  }), [viewModeToggle, callouts, loadingIndicator]);
  if (isDataViewLoading || isEmptyDataResult && isDataLoading) {
    return (
      /*#__PURE__*/
      // class is used in tests
      _react.default.createElement("div", {
        className: "dscDocuments__loading",
        css: styles.dscDocumentsLoading,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 426,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 427,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 428,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 429,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.loadingDocuments",
        defaultMessage: "Loading documents",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 430,
          columnNumber: 11
        }
      })))
    );
  }
  return (
    /*#__PURE__*/
    // class is used in tests
    _react.default.createElement(_eui.EuiFlexItem, {
      className: "dscTable",
      "aria-labelledby": "documentsAriaLabel",
      css: styles.container,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 438,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 439,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "documentsAriaLabel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 440,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.documentsAriaLabel",
      defaultMessage: "Documents",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 441,
        columnNumber: 11
      }
    }))), /*#__PURE__*/_react.default.createElement("div", {
      className: "unifiedDataTable",
      css: styles.dataTable,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 444,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
      getTriggerCompatibleActions: uiActions.getTriggerCompatibleActions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 445,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(DiscoverGridMemoized, {
      ariaLabelledBy: "documentsAriaLabel",
      columns: currentColumns,
      columnsMeta: columnsMeta,
      expandedDoc: expandedDoc,
      dataView: dataView,
      loadingState: isDataLoading ? _unifiedDataTable.DataLoadingState.loading : isMoreDataLoading ? _unifiedDataTable.DataLoadingState.loadingMore : _unifiedDataTable.DataLoadingState.loaded,
      rows: rows,
      sort: sort || [],
      searchDescription: persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.description,
      searchTitle: persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.title // TODO: should it be rather a tab label?
      ,
      setExpandedDoc: setExpandedDoc,
      showTimeCol: showTimeCol,
      settings: grid,
      onFilter: onAddFilter,
      onSetColumns: onSetColumns,
      onSort: onSort,
      onResize: onResizeDataGrid,
      configHeaderRowHeight: 3,
      headerRowHeightState: headerRowHeight,
      onUpdateHeaderRowHeight: onUpdateHeaderRowHeight,
      rowHeightState: rowHeight,
      onUpdateRowHeight: onUpdateRowHeight,
      isSortEnabled: true,
      isPlainRecord: isEsqlMode,
      isPaginationEnabled: !isEsqlMode,
      rowsPerPageState: rowsPerPage !== null && rowsPerPage !== void 0 ? rowsPerPage : (0, _constants.getDefaultRowsPerPage)(services.uiSettings),
      onUpdateRowsPerPage: onUpdateRowsPerPage,
      maxAllowedSampleSize: (0, _get_allowed_sample_size.getMaxAllowedSampleSize)(services.uiSettings),
      sampleSizeState: (0, _get_allowed_sample_size.getAllowedSampleSize)(sampleSizeState, services.uiSettings),
      onUpdateSampleSize: !isEsqlMode ? onUpdateSampleSize : undefined,
      onFieldEdited: onFieldEdited,
      configRowHeight: configRowHeight,
      showMultiFields: uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS),
      maxDocFieldsDisplayed: uiSettings.get(_discoverUtils.MAX_DOC_FIELDS_DISPLAYED),
      renderDocumentView: renderDocumentView,
      renderCustomToolbar: renderCustomToolbarWithElements,
      services: services,
      totalHits: totalHits,
      onFetchMoreRecords: onFetchMoreRecords,
      externalCustomRenderers: cellRenderers,
      rowAdditionalLeadingControls: rowAdditionalLeadingControls,
      dataGridDensityState: density,
      onUpdateDataGridDensity: onUpdateDensity,
      onUpdateESQLQuery: stateContainer.actions.updateESQLQuery,
      query: query,
      cellActionsTriggerId: _context_awareness.DISCOVER_CELL_ACTIONS_TRIGGER.id,
      cellActionsMetadata: cellActionsMetadata,
      cellActionsHandling: "append",
      initialState: dataGridUiState,
      onInitialStateChange: onInitialStateChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 446,
        columnNumber: 11
      }
    }))))
  );
}
const DiscoverDocuments = exports.DiscoverDocuments = /*#__PURE__*/(0, _react.memo)(DiscoverDocumentsComponent);
const componentStyles = {
  container: (0, _react2.css)({
    position: 'relative',
    minHeight: 0
  }),
  progress: (0, _react2.css)({
    zIndex: 2
  }),
  dscDocumentsLoading: (0, _react2.css)({
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    textAlign: 'center',
    height: '100%',
    width: '100%'
  }),
  dataTable: (0, _react2.css)({
    width: '100%',
    maxWidth: '100%',
    height: '100%',
    overflow: 'hidden'
  })
};