"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBandsColorScale = getBandsColorScale;
const colors_1 = require("../../../common/colors");
const predicate_1 = require("../../../common/predicate");
const common_1 = require("../../../utils/common");
function defaultColorBandFormatter(valueFormatter) {
    return (startValue, endValue) => {
        const finiteStart = Number.isFinite(startValue);
        const finiteEnd = Number.isFinite(endValue);
        const start = (0, common_1.safeFormat)(startValue, valueFormatter);
        const end = (0, common_1.safeFormat)(endValue, valueFormatter);
        return !finiteStart && finiteEnd ? `< ${end}` : finiteStart && !finiteEnd ? `≥ ${start}` : `${start} - ${end}`;
    };
}
function getBandsColorScale(colorScale, locale, valueFormatter) {
    const labelFormatter = colorScale.labelFormatter ?? defaultColorBandFormatter(valueFormatter);
    const ascendingSortFn = (0, predicate_1.getPredicateFn)('numAsc', locale, 'start');
    const bands = colorScale.bands
        .reduce((acc, { start, end, color, label }) => {
        if (start < end)
            acc.push({ start, end, color, label: label ?? labelFormatter(start, end) });
        return acc;
    }, [])
        .sort(ascendingSortFn);
    const scale = getBandScale(bands);
    return { scale, bands };
}
function getBandScale(bands) {
    return (value) => {
        if (!(0, common_1.isFiniteNumber)(value)) {
            return colors_1.Colors.Transparent.keyword;
        }
        return bands.find(({ start, end }) => start <= value && value < end)?.color ?? colors_1.Colors.Transparent.keyword;
    };
}
//# sourceMappingURL=band_color_scale.js.map