"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TitlesBlock = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
function lineClamp(maxLines) {
    return {
        textOverflow: 'ellipsis',
        display: '-webkit-box',
        WebkitLineClamp: maxLines,
        lineClamp: maxLines,
        WebkitBoxOrient: 'vertical',
        overflow: 'hidden',
        whiteSpace: 'pre-line',
    };
}
const Title = ({ metricId, title, titleWeight, fontSize, textAlign, linesLength, onElementClick, }) => {
    const contentStyle = {
        fontSize,
        textAlign,
        fontWeight: titleWeight,
        ...lineClamp(linesLength),
    };
    const content = (react_1.default.createElement("span", { title: title, style: contentStyle }, title));
    return (react_1.default.createElement("h2", { id: metricId, className: "echMetricText__title" }, onElementClick ? (react_1.default.createElement("button", { onMouseDown: (e) => e.stopPropagation(), onMouseUp: (e) => e.stopPropagation(), onClick: (e) => {
            e.stopPropagation();
            onElementClick();
        } }, content)) : (content)));
};
const Subtitle = ({ subtitle, fontSize, subtitleLines, color }) => {
    return (react_1.default.createElement("p", { className: "echMetricText__subtitle", style: {
            fontSize,
            color,
            ...lineClamp(subtitleLines.length),
        }, title: subtitle }, subtitle));
};
const TitlesBlock = ({ metricId, title, subtitle, sizes, visibility, textAlign, titleWeight, isIconVisible, titlesRow, titlesColumn, subtitleColor, onElementClick, }) => {
    const { titleFontSize, subtitleFontSize } = sizes;
    const { title: showTitle, subtitle: showSubtitle, titleLines, subtitleLines } = visibility;
    const titlesBlockStyle = (0, react_1.useMemo)(() => {
        if (!isIconVisible)
            return undefined;
        return {
            gridRow: titlesRow,
            gridColumn: titlesColumn,
        };
    }, [isIconVisible, titlesRow, titlesColumn]);
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('echMetricText__titlesBlock', `echMetricText__titlesBlock--${textAlign}`), style: titlesBlockStyle },
        showTitle && (react_1.default.createElement(Title, { metricId: metricId, title: title, fontSize: titleFontSize, textAlign: textAlign, titleWeight: titleWeight, linesLength: titleLines.length, onElementClick: onElementClick })),
        showSubtitle && (react_1.default.createElement(Subtitle, { subtitle: subtitle, fontSize: subtitleFontSize, subtitleLines: subtitleLines, color: subtitleColor }))));
};
exports.TitlesBlock = TitlesBlock;
//# sourceMappingURL=titles.js.map