"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.chartSelectorsFactory = void 0;
const wordcloud_spec_1 = require("./selectors/wordcloud_spec");
const chart_selectors_1 = require("../../../state/chart_selectors");
const get_internal_is_intialized_1 = require("../../../state/selectors/get_internal_is_intialized");
exports.chartSelectorsFactory = (0, chart_selectors_1.createChartSelectorsFactory)({
    isInitialized: (state) => (0, wordcloud_spec_1.getWordcloudSpecSelector)(state) !== null ? get_internal_is_intialized_1.InitStatus.Initialized : get_internal_is_intialized_1.InitStatus.ChartNotInitialized,
    isChartEmpty: () => false,
    getTooltipAnchor: (state) => {
        const { position } = state.interactions.pointer.current;
        return {
            isRotated: false,
            x: position.x,
            width: 0,
            y: position.y,
            height: 0,
        };
    },
    getChartTypeDescription: () => 'Word cloud chart',
});
//# sourceMappingURL=chart_selectors.js.map