"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MIN_LABEL_WIDTH = exports.GRID_ACTION_WIDTH = exports.GRID_COLOR_WIDTH = void 0;
exports.LegendTable = LegendTable;
const react_1 = __importDefault(require("react"));
const legend_table_body_1 = require("./legend_table_body");
const legend_table_header_1 = require("./legend_table_header");
const common_1 = require("../../../utils/common");
exports.GRID_COLOR_WIDTH = 10;
exports.GRID_ACTION_WIDTH = 26;
exports.MIN_LABEL_WIDTH = 24;
function LegendTable({ items, seriesWidth = exports.MIN_LABEL_WIDTH, ...itemProps }) {
    const legendValuesLength = items?.[0]?.values.length ? `repeat(${items?.[0]?.values.length}, auto)` : '';
    const actionComponentWidth = itemProps.action ? `${exports.GRID_ACTION_WIDTH}px` : '';
    const gridTemplateColumns = {
        vertical: `${exports.GRID_COLOR_WIDTH}px minmax(${seriesWidth}px, 1fr) ${legendValuesLength} ${actionComponentWidth}`,
        horizontal: `${exports.GRID_COLOR_WIDTH}px minmax(50%, 1fr) ${legendValuesLength} ${actionComponentWidth}`,
    };
    return (react_1.default.createElement("div", { className: "echLegendTable", role: "table", style: {
            gridTemplateColumns: itemProps.positionConfig.direction === common_1.LayoutDirection.Horizontal
                ? gridTemplateColumns.horizontal
                : gridTemplateColumns.vertical,
        } },
        react_1.default.createElement(legend_table_header_1.LegendTableHeader, { isMostlyRTL: itemProps.isMostlyRTL, hasAction: !!itemProps.action, legendValues: itemProps.legendValues, legendTitle: itemProps.legendTitle, labelOptions: itemProps.labelOptions }),
        react_1.default.createElement(legend_table_body_1.LegendTableBody, { items: items, ...itemProps })));
}
//# sourceMappingURL=legend_table.js.map