"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormControlLayoutDelimited__input = exports.euiFormControlLayoutDelimited__delimiter = exports.euiFormControlLayoutDelimitedStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFormControlLayoutDelimitedStyles = exports.euiFormControlLayoutDelimitedStyles = function euiFormControlLayoutDelimitedStyles(euiThemeContext) {
  var highContrastMode = euiThemeContext.highContrastMode;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var form = (0, _form.euiFormVariables)(euiThemeContext);
  var invalidStyles = isRefreshVariant ? "\n    :not(.euiFormControlLayoutDelimited__input, .euiFormControlLayoutDelimited__delimiter) {\n      ".concat((0, _form.euiFormControlInvalidStyles)(euiThemeContext), "\n    }\n\n    &:focus-within {\n      --euiFormControlStateColor: ").concat(form.borderColor, ";\n      --euiFormControlStateHoverColor: ").concat(form.borderHovered, ";\n    }\n\n    .euiFormControlLayoutDelimited__input {\n      background-color: transparent;\n    }\n  ") : "\n    ".concat((0, _form.euiFormControlInvalidStyles)(euiThemeContext), ";\n  ");
  var readOnlyStyles = "\n      & .euiFormControlLayoutDelimited__input {\n        outline: none;  \n        box-shadow: none;\n        --euiFormControlStateColor: transparent;\n      }\n    ";
  var delimitedStyles = "\n      /* Transition smoothly between disabled/readOnly background color changes */\n      ".concat((0, _form.euiFormControlDefaultShadow)(euiThemeContext, {
    withBorder: isRefreshVariant && !highContrastMode ? true : false,
    withBackground: false,
    withBackgroundAnimation: isRefreshVariant ? false : true
  }), "\n    ").trim();
  var delimitedWrapperStyles = "\n    ".concat((0, _form.euiFormControlDefaultShadow)(euiThemeContext, {
    withBorder: !highContrastMode,
    withBackground: false,
    withBackgroundAnimation: true
  }), "\n  \n    &:hover {\n      ").concat((0, _form.euiFormControlHoverStyles)(euiThemeContext), "\n      box-shadow: none;\n\n      /* using hover styling on wrapper instead of the children inputs */\n      .euiFormControlLayoutDelimited__input:not(:focus) {\n        outline: none;\n        background-color: transparent;\n      }\n    }\n\n    /* adjust for delimited behavior differing from default form layout */\n    > :first-child {\n      ").concat((0, _global_styling.logicalCSS)('border-top-left-radius', 'inherit'), "\n      ").concat((0, _global_styling.logicalCSS)('border-bottom-left-radius', 'inherit'), "\n    }\n\n    > :last-child {\n      ").concat((0, _global_styling.logicalCSS)('border-top-right-radius', 'inherit'), "\n      ").concat((0, _global_styling.logicalCSS)('border-bottom-right-radius', 'inherit'), "\n    }\n  ");
  return {
    // Appended onto existing `euiFormControlLayout` styles
    delimited: /*#__PURE__*/(0, _react.css)(delimitedStyles, ";label:delimited;"),
    disabled: /*#__PURE__*/(0, _react.css)((0, _form.euiFormControlDisabledStyles)(euiThemeContext), ";label:disabled;"),
    readOnly: /*#__PURE__*/(0, _react.css)((0, _form.euiFormControlReadOnlyStyles)(euiThemeContext), " ", isRefreshVariant && readOnlyStyles, ";;label:readOnly;"),
    // Appended onto existing `euiFormControlLayout__childrenWrapper` styles
    childrenWrapper: {
      delimited: /*#__PURE__*/(0, _react.css)("display:flex;", isRefreshVariant && delimitedWrapperStyles, ";;label:delimited;"),
      invalid: /*#__PURE__*/(0, _react.css)((0, _form.euiFormControlDefaultShadow)(euiThemeContext, {
        withBorder: false,
        withBackgroundColor: false,
        withBackgroundAnimation: false
      }), "\n          ".concat(invalidStyles, "\n        "), ";label:invalid;"),
      readOnly: /*#__PURE__*/(0, _react.css)(";label:readOnly;")
    }
  };
};
var euiFormControlLayoutDelimited__delimiter = exports.euiFormControlLayoutDelimited__delimiter = function euiFormControlLayoutDelimited__delimiter(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var experimentalStyles = isRefreshVariant && "\n      ".concat((0, _global_styling.logicalCSS)('padding-horizontal', (0, _global_styling.mathWithUnits)([euiTheme.size.xs, euiTheme.size.xxs], function (x, y) {
    return x + y;
  })), "\n  ");
  return /*#__PURE__*/(0, _react.css)("display:flex;align-self:stretch;flex-grow:0;align-items:center;line-height:1;", experimentalStyles, ";;label:euiFormControlLayoutDelimited__delimiter;");
};
var euiFormControlLayoutDelimited__input = exports.euiFormControlLayoutDelimited__input = function euiFormControlLayoutDelimited__input(euiThemeContext) {
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  return /*#__PURE__*/(0, _react.css)("box-shadow:none;border:none;border-radius:", isRefreshVariant ? '' : '0', ";text-align:center;", (0, _global_styling.logicalCSS)('height', '100%'), ";;label:euiFormControlLayoutDelimited__input;");
};