"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiLinkStyles = exports.euiLinkCSS = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiLinkCSS = exports.euiLinkCSS = function euiLinkCSS(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return "\n    font-weight: ".concat(euiTheme.font.weight.medium, ";\n    ").concat((0, _global_styling.logicalTextAlignCSS)('left'), "\n\n    &:hover {\n      text-decoration: underline;\n    }\n\n    &:focus {\n      ").concat((0, _global_styling.euiFocusRing)(euiThemeContext, 'outset'), "\n      text-decoration: underline;\n      text-decoration-thickness: ").concat(euiTheme.border.width.thick, ";\n    }\n  ");
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "9njbi5-disabled",
  styles: "font-weight:inherit;&:hover{cursor:auto;}&:hover,&:focus,&:target{text-decoration:none;};label:disabled;"
} : {
  name: "9njbi5-disabled",
  styles: "font-weight:inherit;&:hover{cursor:auto;}&:hover,&:focus,&:target{text-decoration:none;};label:disabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiLinkStyles = exports.euiLinkStyles = function euiLinkStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiLink: /*#__PURE__*/(0, _react.css)(euiLinkCSS(euiThemeContext), " user-select:text;&[target='_blank']{position:relative;};label:euiLink;"),
    disabled: _ref,
    // Color styles
    primary: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textPrimary), ";label:primary;"),
    subdued: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textSubdued), ";label:subdued;"),
    success: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textSuccess), ";label:success;"),
    accent: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textAccent), ";label:accent;"),
    danger: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textDanger), ";label:danger;"),
    warning: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textWarning), ";label:warning;"),
    ghost: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.ghost), ";label:ghost;"),
    text: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.textParagraph), ";label:text;")
  };
};
var _colorCSS = function _colorCSS(color) {
  return "\n    color: ".concat(color, ";\n\n    &:target {\n      color: darken(").concat(color, ", 10%);\n    }\n  ");
};