"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultComputedTheme = exports.EuiThemeContext = exports.EuiSystemContext = exports.EuiNestedThemeContext = exports.EuiModificationsContext = exports.EuiHighContrastModeContext = exports.EuiColorModeContext = exports.DEFAULTS = void 0;
var _react = require("react");
var _euiThemeBorealis = require("@elastic/eui-theme-borealis");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var DEFAULTS = exports.DEFAULTS = {
  system: _euiThemeBorealis.EuiThemeBorealis,
  modifications: {},
  colorMode: _utils.DEFAULT_COLOR_MODE,
  highContrastMode: false
};
var EuiSystemContext = exports.EuiSystemContext = /*#__PURE__*/(0, _react.createContext)(DEFAULTS.system);
var EuiModificationsContext = exports.EuiModificationsContext = /*#__PURE__*/(0, _react.createContext)(DEFAULTS.modifications);
var EuiColorModeContext = exports.EuiColorModeContext = /*#__PURE__*/(0, _react.createContext)(DEFAULTS.colorMode);
var EuiHighContrastModeContext = exports.EuiHighContrastModeContext = /*#__PURE__*/(0, _react.createContext)(DEFAULTS.highContrastMode);
var defaultComputedTheme = exports.defaultComputedTheme = (0, _utils.getComputed)(DEFAULTS.system, DEFAULTS.modifications, DEFAULTS.colorMode);
var EuiThemeContext = exports.EuiThemeContext = /*#__PURE__*/(0, _react.createContext)(defaultComputedTheme);
var EuiNestedThemeContext = exports.EuiNestedThemeContext = /*#__PURE__*/(0, _react.createContext)({
  isGlobalTheme: true,
  hasDifferentColorFromGlobalTheme: false,
  bodyColor: '',
  colorClassName: '',
  setGlobalCSSVariables: function setGlobalCSSVariables() {},
  setNearestThemeCSSVariables: function setNearestThemeCSSVariables() {}
});