"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addRootServiceNodeBindingIfContextFree = addRootServiceNodeBindingIfContextFree;
const buildPlanBindingConstraintsList_1 = require("../calculations/buildPlanBindingConstraintsList");
const LazyPlanServiceNode_1 = require("../models/LazyPlanServiceNode");
const addServiceNodeBindingIfContextFree_1 = require("./addServiceNodeBindingIfContextFree");
/**
 * Attach a binding to the root service node if the binding is context-free.
 * @param params The plan parameters.
 * @param serviceNode The service node to attach the binding to.
 * @param binding The binding to attach.
 * @returns True if the binding requires ancestor metadata, false otherwise.
 */
function addRootServiceNodeBindingIfContextFree(params, serviceNode, binding) {
    if (LazyPlanServiceNode_1.LazyPlanServiceNode.is(serviceNode) && !serviceNode.isExpanded()) {
        return {
            isContextFreeBinding: true,
            shouldInvalidateServiceNode: false,
        };
    }
    const bindingConstraintsList = (0, buildPlanBindingConstraintsList_1.buildPlanBindingConstraintsList)(params);
    const chained = params.rootConstraints.isMultiple && params.rootConstraints.chained;
    return (0, addServiceNodeBindingIfContextFree_1.addServiceNodeBindingIfContextFree)(params, serviceNode, binding, bindingConstraintsList, chained);
}
//# sourceMappingURL=addRootServiceNodeBindingIfContextFree.js.map