"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasReachedTheQueuedActionsLimit = hasReachedTheQueuedActionsLimit;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function hasReachedTheQueuedActionsLimit(taskManager, configurationUtilities, numberOfActions) {
  var _total$value;
  const limit = configurationUtilities.getMaxQueued();
  const {
    hits: {
      total
    }
  } = await taskManager.aggregate({
    query: {
      bool: {
        filter: {
          bool: {
            must: [{
              term: {
                'task.scope': 'actions'
              }
            }]
          }
        }
      }
    },
    aggs: {}
  });
  const tasks = typeof total === 'number' ? total : (_total$value = total === null || total === void 0 ? void 0 : total.value) !== null && _total$value !== void 0 ? _total$value : 0;
  const numberOfTasks = tasks + numberOfActions;
  const hasReachedLimit = numberOfTasks >= limit;
  return {
    hasReachedLimit,
    numberOverLimit: hasReachedLimit ? numberOfTasks - limit : 0
  };
}