"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogRateAnalysisBarColors = exports.RANDOM_SAMPLER_SEED = exports.LOG_RATE_ANALYSIS_SETTINGS = exports.LOG_RATE_ANALYSIS_DATA_VIEW_REF_NAME = exports.EMBEDDABLE_LOG_RATE_ANALYSIS_TYPE = exports.CASES_ATTACHMENT_LOG_RATE_ANALYSIS = void 0;
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Log rate analysis settings */
const LOG_RATE_ANALYSIS_SETTINGS = exports.LOG_RATE_ANALYSIS_SETTINGS = {
  /**
   * The p-value threshold to be used for statistically significant items.
   */
  P_VALUE_THRESHOLD: 0.02,
  /**
   * The minimum support value to be used for the frequent item sets aggration.
   */
  FREQUENT_ITEMS_SETS_MINIMUM_SUPPORT: 0.001,
  /**
   * The maximum values per field to be used for the frequent item sets aggration.
   */
  FREQUENT_ITEMS_SETS_FIELD_VALUE_LIMIT: 50,
  /**
   * The number of terms by field to fetch for the zero docs fallback analysis.
   */
  TOP_TERMS_FALLBACK_SIZE: 100
};

/**
 * For the technical preview of Log Rate Analysis we use a hard coded seed.
 * In future versions we might use a user specific seed or let the user customise it.
 */
const RANDOM_SAMPLER_SEED = exports.RANDOM_SAMPLER_SEED = 3867412;

/** Highlighting color for charts */
const useLogRateAnalysisBarColors = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    barColor: euiTheme.flags.hasVisColorAdjustment ? euiTheme.colors.vis.euiColorVis0 : euiTheme.colors.vis.euiColorVis0,
    barHighlightColor: euiTheme.flags.hasVisColorAdjustment ? 'orange' : euiTheme.colors.vis.euiColorVis8
  };
};

/**  */
exports.useLogRateAnalysisBarColors = useLogRateAnalysisBarColors;
const EMBEDDABLE_LOG_RATE_ANALYSIS_TYPE = exports.EMBEDDABLE_LOG_RATE_ANALYSIS_TYPE = 'aiopsLogRateAnalysisEmbeddable';

/**  */
const LOG_RATE_ANALYSIS_DATA_VIEW_REF_NAME = exports.LOG_RATE_ANALYSIS_DATA_VIEW_REF_NAME = 'aiopsLogRateAnalysisEmbeddableDataViewId';
const CASES_ATTACHMENT_LOG_RATE_ANALYSIS = exports.CASES_ATTACHMENT_LOG_RATE_ANALYSIS = 'aiopsLogRateAnalysisEmbeddable';