"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.commonColumns = exports.clearAllRowState = exports.AIOPS_LOG_RATE_ANALYSIS_RESULT_COLUMNS = void 0;
exports.getPreloadedState = getPreloadedState;
exports.significantItemColumns = exports.setSkippedColumns = exports.setSelectedSignificantItem = exports.setSelectedGroup = exports.setPinnedSignificantItem = exports.setPinnedGroup = exports.logRateAnalysisTableSlice = exports.localStorageListenerMiddleware = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AIOPS_LOG_RATE_ANALYSIS_RESULT_COLUMNS = exports.AIOPS_LOG_RATE_ANALYSIS_RESULT_COLUMNS = 'aiops.logRateAnalysisResultColumns';
const commonColumns = exports.commonColumns = {
  ['Log rate']: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.logRateColumnTitle', {
    defaultMessage: 'Log rate'
  }),
  ['Doc count']: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.docCountColumnTitle', {
    defaultMessage: 'Doc count'
  }),
  ['p-value']: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.pValueColumnTitle', {
    defaultMessage: 'p-value'
  }),
  ['Impact']: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.impactColumnTitle', {
    defaultMessage: 'Impact'
  }),
  ['Baseline rate']: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.baselineRateColumnTitle', {
    defaultMessage: 'Baseline rate'
  }),
  ['Deviation rate']: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.deviationRateColumnTitle', {
    defaultMessage: 'Deviation rate'
  }),
  ['Log rate change']: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.logRateChangeColumnTitle', {
    defaultMessage: 'Log rate change'
  }),
  ['Actions']: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.actionsColumnTitle', {
    defaultMessage: 'Actions'
  })
};
const significantItemColumns = exports.significantItemColumns = {
  ['Field name']: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.fieldNameColumnTitle', {
    defaultMessage: 'Field name'
  }),
  ['Field value']: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.fieldValueColumnTitle', {
    defaultMessage: 'Field value'
  }),
  ...commonColumns
};
function getDefaultState() {
  return {
    skippedColumns: ['p-value', 'Baseline rate', 'Deviation rate'],
    pinnedGroup: null,
    pinnedSignificantItem: null,
    selectedGroup: null,
    selectedSignificantItem: null
  };
}
function getPreloadedState() {
  const defaultState = getDefaultState();
  const localStorageSkippedColumns = localStorage.getItem(AIOPS_LOG_RATE_ANALYSIS_RESULT_COLUMNS);
  if (localStorageSkippedColumns === null) {
    return defaultState;
  }
  try {
    defaultState.skippedColumns = JSON.parse(localStorageSkippedColumns);
  } catch (err) {
    // eslint-disable-next-line no-console
    console.warn('Failed to parse skipped columns from local storage:', err);
  }
  return defaultState;
}
const logRateAnalysisTableSlice = exports.logRateAnalysisTableSlice = (0, _toolkit.createSlice)({
  name: 'logRateAnalysisTable',
  initialState: getDefaultState(),
  reducers: {
    clearAllRowState: state => {
      state.pinnedGroup = null;
      state.pinnedSignificantItem = null;
      state.selectedGroup = null;
      state.selectedSignificantItem = null;
    },
    setPinnedGroup: (state, action) => {
      state.pinnedGroup = action.payload;
    },
    setPinnedSignificantItem: (state, action) => {
      state.pinnedSignificantItem = action.payload;
    },
    setSelectedGroup: (state, action) => {
      state.selectedGroup = action.payload;
    },
    setSelectedSignificantItem: (state, action) => {
      state.selectedSignificantItem = action.payload;
    },
    setSkippedColumns: (state, action) => {
      state.skippedColumns = action.payload;
    }
  }
});

// Action creators are generated for each case reducer function
const {
  clearAllRowState,
  setPinnedGroup,
  setPinnedSignificantItem,
  setSelectedGroup,
  setSelectedSignificantItem,
  setSkippedColumns
} = logRateAnalysisTableSlice.actions;

// Create listener middleware
exports.setSkippedColumns = setSkippedColumns;
exports.setSelectedSignificantItem = setSelectedSignificantItem;
exports.setSelectedGroup = setSelectedGroup;
exports.setPinnedSignificantItem = setPinnedSignificantItem;
exports.setPinnedGroup = setPinnedGroup;
exports.clearAllRowState = clearAllRowState;
const localStorageListenerMiddleware = exports.localStorageListenerMiddleware = (0, _toolkit.createListenerMiddleware)();

// Add a listener to save skippedColumns to localStorage whenever it changes
localStorageListenerMiddleware.startListening({
  actionCreator: setSkippedColumns,
  effect: (action, listenerApi) => {
    const state = listenerApi.getState();
    try {
      const serializedState = JSON.stringify(state.logRateAnalysisTable.skippedColumns);
      localStorage.setItem(AIOPS_LOG_RATE_ANALYSIS_RESULT_COLUMNS, serializedState);
    } catch (err) {
      // eslint-disable-next-line no-console
      console.warn('Failed to save state to localStorage:', err);
    }
  }
});