"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _rxjs = require("rxjs");
var _constants = require("@kbn/aiops-common/constants");
var _dataService = require("@kbn/data-service");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _use_aiops_app_context = require("../hooks/use_aiops_app_context");
var _use_data_source = require("../hooks/use_data_source");
var _use_reload = require("../hooks/use_reload");
var _use_filters_query = require("../hooks/use_filters_query");
var _log_rate_analysis_for_embeddable = require("../components/log_rate_analysis/log_rate_analysis_for_embeddable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/aiops/public/shared_components/log_rate_analysis_embeddable_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Only used to initialize internally
 */

const LogRateAnalysisEmbeddableWrapperWithDeps = ({
  // Component dependencies
  coreStart,
  pluginStart,
  // Component props
  dataViewId,
  timeRange,
  embeddingOrigin,
  lastReloadRequestTime,
  windowParameters,
  filtersApi
}) => {
  const deps = (0, _react.useMemo)(() => {
    const {
      lens,
      data,
      usageCollection,
      fieldFormats,
      charts,
      share,
      storage,
      unifiedSearch
    } = pluginStart;
    return {
      data,
      lens,
      usageCollection,
      fieldFormats,
      charts,
      share,
      storage,
      unifiedSearch,
      ...coreStart
    };
  }, [coreStart, pluginStart]);
  const datePickerDeps = {
    ...(0, _lodash.pick)(deps, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    uiSettingsKeys: _dataService.UI_SETTINGS
  };
  const aiopsAppContextValue = (0, _react.useMemo)(() => {
    return {
      embeddingOrigin: embeddingOrigin !== null && embeddingOrigin !== void 0 ? embeddingOrigin : _constants.AIOPS_EMBEDDABLE_ORIGIN.DEFAULT,
      ...deps
    };
  }, [deps, embeddingOrigin]);
  const [manualReload$] = (0, _react.useState)(new _rxjs.BehaviorSubject(lastReloadRequestTime !== null && lastReloadRequestTime !== void 0 ? lastReloadRequestTime : Date.now()));
  (0, _react.useEffect)(function updateManualReloadSubject() {
    if (!lastReloadRequestTime) return;
    manualReload$.next(lastReloadRequestTime);
  }, [lastReloadRequestTime, manualReload$]);
  const resultObservable$ = (0, _react.useMemo)(() => {
    return (0, _rxjs.combineLatest)([manualReload$]).pipe((0, _rxjs.map)(([manualReload]) => Math.max(manualReload)), (0, _rxjs.distinctUntilChanged)());
  }, [manualReload$]);

  // We use the following pattern to track changes of dataViewId, and if there's
  // a change, we unmount and remount the complete inner component. This makes
  // sure the component is reinitialized correctly when the options of the
  // dashboard panel are used to change the data view. This is a bit of a
  // workaround since originally log rate analysis was developed as a standalone
  // page with the expectation that the data view is set once and never changes.
  const prevDataViewId = (0, _usePrevious.default)(dataViewId);
  const [_, setRerenderFlag] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (prevDataViewId && prevDataViewId !== dataViewId) {
      setRerenderFlag(prev => !prev);
    }
  }, [dataViewId, prevDataViewId]);
  const showComponent = prevDataViewId === undefined || prevDataViewId === dataViewId;

  // TODO: Remove data-shared-item as part of https://github.com/elastic/kibana/issues/179376>
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-shared-item": "",
    "data-test-subj": "aiopsEmbeddableLogRateAnalysis",
    css: {
      width: '100%',
      height: '100%',
      overflowY: 'auto',
      padding: '10px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, showComponent && /*#__PURE__*/_react.default.createElement(_use_reload.ReloadContextProvider, {
    reload$: resultObservable$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: aiopsAppContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, (0, _extends2.default)({}, datePickerDeps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContextProvider, {
    dataViews: pluginStart.data.dataViews,
    dataViewId: dataViewId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_use_filters_query.FilterQueryContextProvider, {
    timeRange: timeRange,
    filtersApi: filtersApi,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_state.LogRateAnalysisReduxProvider, {
    initialAnalysisStart: windowParameters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_log_rate_analysis_for_embeddable.LogRateAnalysisForEmbeddable, {
    timeRange: timeRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 21
    }
  }))))))));
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LogRateAnalysisEmbeddableWrapperWithDeps;
module.exports = exports.default;