"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleIdsSchema = exports.bulkEditRuleSnoozeScheduleSchema = exports.bulkEditOperationsSchema = exports.bulkEditOperationSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _schemas = require("../../../schemas");
var _r_rule = require("../../../../../../common/routes/r_rule");
var _validation = require("../../../validation");
var _validation2 = require("../validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scheduleIdsSchema = exports.scheduleIdsSchema = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()));
const bulkEditRuleSnoozeScheduleSchema = exports.bulkEditRuleSnoozeScheduleSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  duration: _configSchema.schema.number(),
  rRule: _r_rule.rRuleRequestSchema
});
const bulkEditRuleSnoozeScheduleSchemaWithValidation = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  duration: _configSchema.schema.number(),
  rRule: _r_rule.rRuleRequestSchema
}, {
  validate: _validation2.validateSnoozeSchedule
});
const bulkEditTagSchema = _configSchema.schema.object({
  operation: _configSchema.schema.oneOf([_configSchema.schema.literal('add'), _configSchema.schema.literal('delete'), _configSchema.schema.literal('set')]),
  field: _configSchema.schema.literal('tags'),
  value: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const bulkEditActionsSchema = _configSchema.schema.object({
  operation: _configSchema.schema.oneOf([_configSchema.schema.literal('add'), _configSchema.schema.literal('set')]),
  field: _configSchema.schema.literal('actions'),
  value: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_schemas.actionRequestSchema, _schemas.systemActionRequestSchema]))
});
const bulkEditScheduleSchema = _configSchema.schema.object({
  operation: _configSchema.schema.literal('set'),
  field: _configSchema.schema.literal('schedule'),
  value: _configSchema.schema.object({
    interval: _configSchema.schema.string({
      validate: _validation.validateDuration
    })
  })
});
const bulkEditThrottleSchema = _configSchema.schema.object({
  operation: _configSchema.schema.literal('set'),
  field: _configSchema.schema.literal('throttle'),
  value: _configSchema.schema.nullable(_configSchema.schema.string())
});
const bulkEditNotifyWhenSchema = _configSchema.schema.object({
  operation: _configSchema.schema.literal('set'),
  field: _configSchema.schema.literal('notifyWhen'),
  value: _schemas.notifyWhenSchema
});
const bulkEditSnoozeSchema = _configSchema.schema.object({
  operation: _configSchema.schema.oneOf([_configSchema.schema.literal('set')]),
  field: _configSchema.schema.literal('snoozeSchedule'),
  value: bulkEditRuleSnoozeScheduleSchemaWithValidation
});
const bulkEditUnsnoozeSchema = _configSchema.schema.object({
  operation: _configSchema.schema.oneOf([_configSchema.schema.literal('delete')]),
  field: _configSchema.schema.literal('snoozeSchedule'),
  value: _configSchema.schema.maybe(scheduleIdsSchema)
});
const bulkEditApiKeySchema = _configSchema.schema.object({
  operation: _configSchema.schema.literal('set'),
  field: _configSchema.schema.literal('apiKey')
});
const bulkEditOperationSchema = exports.bulkEditOperationSchema = _configSchema.schema.oneOf([bulkEditTagSchema, bulkEditActionsSchema, bulkEditScheduleSchema, bulkEditThrottleSchema, bulkEditNotifyWhenSchema, bulkEditSnoozeSchema, bulkEditUnsnoozeSchema, bulkEditApiKeySchema]);
const bulkEditOperationsSchema = exports.bulkEditOperationsSchema = _configSchema.schema.arrayOf(bulkEditOperationSchema, {
  minSize: 1
});