"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toBulkGapFillError = exports.logProcessedAsAuditEvent = void 0;
var _types = require("./types");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _saved_objects = require("../../../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toBulkGapFillError = (rule, step, error) => {
  var _error$message;
  let fallbackMessage;
  switch (step) {
    case _types.BulkGapsFillStep.SCHEDULING:
      fallbackMessage = 'Error scheduling backfills';
      break;
    case _types.BulkGapsFillStep.ACCESS_VALIDATION:
      fallbackMessage = 'Error validating user access to the rule';
      break;
  }
  return {
    rule: {
      id: rule.id,
      name: rule.name
    },
    step,
    errorMessage: (_error$message = error === null || error === void 0 ? void 0 : error.message) !== null && _error$message !== void 0 ? _error$message : fallbackMessage
  };
};
exports.toBulkGapFillError = toBulkGapFillError;
const logProcessedAsAuditEvent = (context, {
  id,
  name
}, error) => {
  var _context$auditLogger;
  const payload = {
    action: _audit_events.RuleAuditAction.FILL_GAPS,
    savedObject: {
      type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
      id,
      name
    }
  };
  if (error) {
    payload.error = error;
  }
  (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)(payload));
};
exports.logProcessedAsAuditEvent = logProcessedAsAuditEvent;