"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRule = getRule;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _authorization = require("../../../../authorization");
var _rule = require("../../../../data/rule");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _saved_objects = require("../../../../saved_objects");
var _schemas = require("./schemas");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getRule(context, params) {
  var _context$auditLogger2;
  try {
    _schemas.getRuleParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating get data - ${error.message}`);
  }
  const {
    id
  } = params;
  const result = await (0, _rule.getRuleSo)({
    savedObjectsClient: context.unsecuredSavedObjectsClient,
    id
  });
  try {
    await context.authorization.ensureAuthorized({
      ruleTypeId: result.attributes.alertTypeId,
      consumer: result.attributes.consumer,
      operation: _authorization.ReadOperations.Get,
      entity: _authorization.AlertingAuthorizationEntity.Rule
    });
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.GET,
      savedObject: {
        type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
        id,
        name: result.attributes.name
      },
      error
    }));
    throw error;
  }
  (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.GET,
    savedObject: {
      type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
      id,
      name: result.attributes.name
    }
  }));
  return (0, _utils.transformToSanitizedRule)(context, result, params);
}