"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleTemplate = getRuleTemplate;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _authorization = require("../../../../authorization");
var _rule_template = require("../../../../data/rule_template");
var _schema = require("./schema");
var _transform_raw_rule_template_to_rule_template = require("../../transforms/transform_raw_rule_template_to_rule_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getRuleTemplate(context, params) {
  try {
    _schema.getRuleTemplateParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating get data - ${error.message}`);
  }
  const {
    id
  } = params;
  const result = await (0, _rule_template.getRuleTemplateSo)({
    savedObjectsClient: context.unsecuredSavedObjectsClient,
    id
  });
  try {
    var _authzResult$authoriz, _authzResult$authoriz2;
    const authzResult = await context.authorization.getAllAuthorizedRuleTypes({
      authorizationEntity: _authorization.AlertingAuthorizationEntity.Rule,
      operations: [_authorization.ReadOperations.Get]
    });
    let isAuthorized = false;
    const authorizedConsumers = (_authzResult$authoriz = (_authzResult$authoriz2 = authzResult.authorizedRuleTypes.get(result.attributes.ruleTypeId)) === null || _authzResult$authoriz2 === void 0 ? void 0 : _authzResult$authoriz2.authorizedConsumers) !== null && _authzResult$authoriz !== void 0 ? _authzResult$authoriz : {};
    for (const authorizedConsumer of Object.values(authorizedConsumers)) {
      if (authorizedConsumer.read) {
        isAuthorized = true;
        break;
      }
    }
    if (!isAuthorized) {
      throw _boom.default.forbidden(`Unauthorized to get "${result.attributes.ruleTypeId}" RuleTemplate`);
    }
  } catch (error) {
    throw error;
  }
  return (0, _transform_raw_rule_template_to_rule_template.transformRawRuleTemplateToRuleTemplate)({
    id: result.id,
    attributes: result.attributes
  });
}