"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateConnectorAdapterActionParams = exports.bulkValidateConnectorAdapterActionParams = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateConnectorAdapterActionParams = ({
  connectorAdapterRegistry,
  connectorTypeId,
  params
}) => {
  if (!connectorTypeId) {
    return;
  }
  if (!connectorAdapterRegistry.has(connectorTypeId)) {
    return;
  }
  const connectorAdapter = connectorAdapterRegistry.get(connectorTypeId);
  const schema = connectorAdapter.ruleActionParamsSchema;
  try {
    schema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Invalid system action params. System action type: ${connectorAdapter.connectorTypeId} - ${error.message}`);
  }
};
exports.validateConnectorAdapterActionParams = validateConnectorAdapterActionParams;
const bulkValidateConnectorAdapterActionParams = ({
  connectorAdapterRegistry,
  actions
}) => {
  for (const action of actions) {
    validateConnectorAdapterActionParams({
      connectorAdapterRegistry,
      connectorTypeId: action.actionTypeId,
      params: action.params
    });
  }
};
exports.bulkValidateConnectorAdapterActionParams = bulkValidateConnectorAdapterActionParams;