"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRequestToAlertDeleteSchedule = exports.transformRequestToAlertDeletePreview = void 0;
var _get_category_ids = require("./get_category_ids");
var _get_space_ids = require("./get_space_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformRequestToAlertDeletePreview = ({
  active_alert_delete_threshold: activeAlertDeleteThreshold,
  inactive_alert_delete_threshold: inactiveAlertDeleteThreshold,
  category_ids: _categoryIds
}) => {
  return {
    isActiveAlertDeleteEnabled: Boolean(activeAlertDeleteThreshold),
    isInactiveAlertDeleteEnabled: Boolean(inactiveAlertDeleteThreshold),
    activeAlertDeleteThreshold: activeAlertDeleteThreshold || 1,
    inactiveAlertDeleteThreshold: inactiveAlertDeleteThreshold || 1,
    categoryIds: (0, _get_category_ids.getCategoryIds)(_categoryIds)
  };
};
exports.transformRequestToAlertDeletePreview = transformRequestToAlertDeletePreview;
const transformRequestToAlertDeleteSchedule = ({
  active_alert_delete_threshold: activeAlertDeleteThreshold,
  inactive_alert_delete_threshold: inactiveAlertDeleteThreshold,
  category_ids: categoryIds,
  space_ids: spaceIds
}) => {
  return {
    isActiveAlertDeleteEnabled: Boolean(activeAlertDeleteThreshold),
    isInactiveAlertDeleteEnabled: Boolean(inactiveAlertDeleteThreshold),
    activeAlertDeleteThreshold: activeAlertDeleteThreshold || 1,
    inactiveAlertDeleteThreshold: inactiveAlertDeleteThreshold || 1,
    categoryIds: (0, _get_category_ids.getCategoryIds)(categoryIds),
    spaceIds: (0, _get_space_ids.getSpaceIds)(spaceIds)
  };
};
exports.transformRequestToAlertDeleteSchedule = transformRequestToAlertDeleteSchedule;