"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFindMaintenanceWindowResponse = void 0;
var _transforms = require("../../../common/transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformFindMaintenanceWindowResponse = result => {
  return {
    page: result.page,
    per_page: result.perPage,
    total: result.total,
    maintenanceWindows: result.data.map(maintenanceWindow => (0, _transforms.transformInternalMaintenanceWindowToExternalV1)(maintenanceWindow))
  };
};
exports.transformFindMaintenanceWindowResponse = transformFindMaintenanceWindowResponse;