"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScheduleFrequencyRoute = void 0;
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("./transforms");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getScheduleFrequencyRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/_schedule_frequency`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {}
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async (context, req, res) => {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const scheduleFrequencyResult = await rulesClient.getScheduleFrequency();
    const response = {
      body: (0, _transforms.transformGetScheduleFrequencyResultV1)(scheduleFrequencyResult)
    };
    return res.ok(response);
  })));
};
exports.getScheduleFrequencyRoute = getScheduleFrequencyRoute;