"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearExpiredSnoozes = clearExpiredSnoozes;
var _lib = require("../../lib");
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function clearExpiredSnoozes(opts) {
  var _rule$snoozeSchedule;
  const {
    esClient,
    logger,
    rule,
    version
  } = opts;
  if (!rule.snoozeSchedule || !rule.snoozeSchedule.length) return;
  const snoozeSchedule = rule.snoozeSchedule ? rule.snoozeSchedule.filter(s => {
    try {
      return !(0, _lib.isSnoozeExpired)(s);
    } catch (e) {
      logger.error(`Error checking for expiration of snooze ${s.id}: ${e}`);
      return true;
    }
  }) : [];
  if (snoozeSchedule.length === ((_rule$snoozeSchedule = rule.snoozeSchedule) === null || _rule$snoozeSchedule === void 0 ? void 0 : _rule$snoozeSchedule.length)) return;
  const updateAttributes = {
    snoozeSchedule
  };
  const updateOptions = {
    version,
    refresh: false
  };
  await (0, _saved_objects.partiallyUpdateRuleWithEs)(esClient, rule.id, updateAttributes, updateOptions);
}