"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateAlertInstances = migrateAlertInstances;
exports.migrateLastScheduledActions = migrateLastScheduledActions;
exports.migrateMeta = migrateMeta;
exports.migrateThrottledActions = migrateThrottledActions;
exports.upMigration = void 0;
var _lib = require("../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function migrateThrottledActions(throttledActions) {
  if (!(0, _lib.isJSONObject)(throttledActions)) {
    return;
  }
  return Object.keys(throttledActions).reduce((acc, key) => {
    const val = throttledActions[key];
    if ((0, _lib.isJSONObject)(val) && (0, _lib.isString)(val.date)) {
      acc[key] = {
        date: val.date
      };
    }
    return acc;
  }, {});
}
function migrateLastScheduledActions(lastScheduledActions) {
  if (!(0, _lib.isJSONObject)(lastScheduledActions) || !(0, _lib.isString)(lastScheduledActions.group) || !(0, _lib.isString)(lastScheduledActions.date)) {
    return;
  }
  return {
    subgroup: (0, _lib.isString)(lastScheduledActions.subgroup) ? lastScheduledActions.subgroup : undefined,
    group: lastScheduledActions.group,
    date: lastScheduledActions.date,
    actions: migrateThrottledActions(lastScheduledActions.actions)
  };
}
function migrateMeta(meta) {
  if (!(0, _lib.isJSONObject)(meta)) {
    return;
  }
  return {
    lastScheduledActions: migrateLastScheduledActions(meta.lastScheduledActions),
    flappingHistory: (0, _lib.isBooleanArray)(meta.flappingHistory) ? meta.flappingHistory : undefined,
    flapping: (0, _lib.isBoolean)(meta.flapping) ? meta.flapping : undefined,
    maintenanceWindowIds: (0, _lib.isStringArray)(meta.maintenanceWindowIds) ? meta.maintenanceWindowIds : undefined,
    pendingRecoveredCount: (0, _lib.isNumber)(meta.pendingRecoveredCount) ? meta.pendingRecoveredCount : undefined,
    activeCount: (0, _lib.isNumber)(meta.activeCount) ? meta.activeCount : undefined,
    uuid: (0, _lib.isString)(meta.uuid) ? meta.uuid : undefined
  };
}
function migrateAlertInstances(alertInstances) {
  if (!(0, _lib.isJSONObject)(alertInstances)) {
    return;
  }
  return Object.keys(alertInstances).reduce((acc, key) => {
    const val = alertInstances[key];
    if ((0, _lib.isJSONObject)(val)) {
      acc[key] = {
        meta: migrateMeta(val.meta),
        state: (0, _lib.isJSONObject)(val.state) ? val.state : undefined
      };
    }
    return acc;
  }, {});
}
const upMigration = state => {
  return {
    alertTypeState: (0, _lib.isJSONObject)(state.alertTypeState) ? state.alertTypeState : undefined,
    alertInstances: migrateAlertInstances(state.alertInstances),
    alertRecoveredInstances: migrateAlertInstances(state.alertRecoveredInstances),
    previousStartedAt: (0, _lib.isString)(state.previousStartedAt) ? state.previousStartedAt : undefined,
    summaryActions: migrateThrottledActions(state.summaryActions)
  };
};
exports.upMigration = upMigration;