"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPaths = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPaths = ({
  spans
}) => {
  const connections = [];
  const exitSpanDestinations = [];
  for (const currentNode of spans) {
    const exitSpanNode = (0, _utils.getExternalConnectionNode)(currentNode);
    const serviceNode = (0, _utils.getServiceConnectionNode)(currentNode);
    if (currentNode.destinationService) {
      // maps an exit span to its destination service
      exitSpanDestinations.push({
        from: exitSpanNode,
        to: (0, _utils.getServiceConnectionNode)(currentNode.destinationService)
      });
    }

    // builds a connection between a service and an exit span
    connections.push([serviceNode, exitSpanNode]);
  }
  return {
    connections: (0, _utils.getConnections)(connections),
    exitSpanDestinations
  };
};
exports.getPaths = getPaths;