"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmTutorialCustomIntegration = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APM_INTEGRATION_CATEGORIES = ['observability', 'apm'];
const apmTutorialCustomIntegration = exports.apmTutorialCustomIntegration = {
  id: 'apm',
  title: _i18n.i18n.translate('xpack.apm.tutorial.specProvider.name', {
    defaultMessage: 'APM'
  }),
  categories: APM_INTEGRATION_CATEGORIES,
  uiInternalPath: '/app/apm/onboarding',
  description: _i18n.i18n.translate('xpack.apm.tutorial.introduction', {
    defaultMessage: 'Collect performance metrics from your applications with Elastic APM.'
  }),
  icons: [{
    type: 'eui',
    src: 'apmApp'
  }],
  shipper: 'tutorial',
  isBeta: false
};