"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimepickerRisonData = getTimepickerRisonData;
var _url_helpers = require("./url_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTimepickerRisonData(currentSearch) {
  const currentQuery = (0, _url_helpers.toQuery)(currentSearch);
  return {
    time: {
      from: currentQuery.rangeFrom || '',
      to: currentQuery.rangeTo || ''
    },
    refreshInterval: {
      pause: currentQuery.refreshPaused ? Boolean(currentQuery.refreshPaused) : true,
      value: currentQuery.refreshInterval ? parseInt(currentQuery.refreshInterval, 10) : 0
    }
  };
}