"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExitSpanChangePoints = getExitSpanChangePoints;
exports.getServiceChangePoints = getServiceChangePoints;
var _latency_aggregation_types = require("../../../../common/latency_aggregation_types");
var _get_apm_timeseries = require("../get_apm_timeseries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceChangePoints({
  apmEventClient,
  start,
  end,
  serviceName,
  serviceEnvironment,
  transactionType,
  transactionName
}) {
  if (!serviceName) {
    return [];
  }
  const res = await (0, _get_apm_timeseries.getApmTimeseries)({
    apmEventClient,
    arguments: {
      start,
      end,
      stats: [{
        title: 'Latency',
        'service.name': serviceName,
        'service.environment': serviceEnvironment,
        timeseries: {
          name: _get_apm_timeseries.ApmTimeseriesType.transactionLatency,
          function: _latency_aggregation_types.LatencyAggregationType.p95,
          'transaction.type': transactionType,
          'transaction.name': transactionName
        }
      }, {
        title: 'Throughput',
        'service.name': serviceName,
        'service.environment': serviceEnvironment,
        timeseries: {
          name: _get_apm_timeseries.ApmTimeseriesType.transactionThroughput,
          'transaction.type': transactionType,
          'transaction.name': transactionName
        }
      }, {
        title: 'Failure rate',
        'service.name': serviceName,
        'service.environment': serviceEnvironment,
        timeseries: {
          name: _get_apm_timeseries.ApmTimeseriesType.transactionFailureRate,
          'transaction.type': transactionType,
          'transaction.name': transactionName
        }
      }, {
        title: 'Error events',
        'service.name': serviceName,
        'service.environment': serviceEnvironment,
        timeseries: {
          name: _get_apm_timeseries.ApmTimeseriesType.errorEventRate
        }
      }]
    }
  });
  return res.filter(timeseries => timeseries.changes.length > 0).map(timeseries => ({
    title: timeseries.stat.title,
    grouping: timeseries.id,
    changes: timeseries.changes
  }));
}
async function getExitSpanChangePoints({
  apmEventClient,
  start,
  end,
  serviceName,
  serviceEnvironment
}) {
  if (!serviceName) {
    return [];
  }
  const res = await (0, _get_apm_timeseries.getApmTimeseries)({
    apmEventClient,
    arguments: {
      start,
      end,
      stats: [{
        title: 'Exit span latency',
        'service.name': serviceName,
        'service.environment': serviceEnvironment,
        timeseries: {
          name: _get_apm_timeseries.ApmTimeseriesType.exitSpanLatency
        }
      }, {
        title: 'Exit span failure rate',
        'service.name': serviceName,
        'service.environment': serviceEnvironment,
        timeseries: {
          name: _get_apm_timeseries.ApmTimeseriesType.exitSpanFailureRate
        }
      }]
    }
  });
  return res.filter(timeseries => timeseries.changes.length > 0).map(timeseries => {
    return {
      title: timeseries.stat.title,
      grouping: timeseries.id,
      changes: timeseries.changes
    };
  });
}