"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpstreamServicesForDependency = getUpstreamServicesForDependency;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
var _get_connection_stats = require("../../lib/connections/get_connection_stats");
var _get_connection_stats_items_with_relative_impact = require("../../lib/connections/get_connection_stats/get_connection_stats_items_with_relative_impact");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getUpstreamServicesForDependencyForTimeRange({
  apmEventClient,
  start,
  end,
  dependencyName,
  numBuckets,
  kuery,
  environment,
  offset,
  randomSampler
}) {
  const {
    statsItems
  } = await (0, _get_connection_stats.getConnectionStats)({
    apmEventClient,
    start,
    end,
    filter: [{
      term: {
        [_apm.SPAN_DESTINATION_SERVICE_RESOURCE]: dependencyName
      }
    }, ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)],
    collapseBy: 'upstream',
    numBuckets,
    offset,
    randomSampler
  });
  return (0, _get_connection_stats_items_with_relative_impact.getConnectionStatsItemsWithRelativeImpact)(statsItems);
}
async function getUpstreamServicesForDependency(options) {
  const {
    offset,
    ...otherOptions
  } = options;
  const [currentServices, previousServices] = await Promise.all([getUpstreamServicesForDependencyForTimeRange(otherOptions), offset ? getUpstreamServicesForDependencyForTimeRange({
    ...otherOptions,
    offset
  }) : Promise.resolve([])]);
  return {
    services: currentServices.map(service => {
      var _prev$stats;
      const {
        stats,
        ...rest
      } = service;
      const prev = previousServices.find(item => item.location.id === service.location.id);
      return {
        ...rest,
        currentStats: stats,
        previousStats: (_prev$stats = prev === null || prev === void 0 ? void 0 : prev.stats) !== null && _prev$stats !== void 0 ? _prev$stats : null
      };
    })
  };
}