"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnvironments = getEnvironments;
var _apm = require("../../../common/es_fields/apm");
var _environment_filter_values = require("../../../common/environment_filter_values");
var _has_unset_value_for_field = require("./has_unset_value_for_field");
var _get_suggestions_with_terms_aggregation = require("../suggestions/get_suggestions_with_terms_aggregation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is used for getting the list of environments for the environment selector,
 * filtered by range.
 */
async function getEnvironments({
  searchAggregatedTransactions,
  serviceName,
  apmEventClient,
  size,
  start,
  end
}) {
  const [hasUnsetEnvironments, resp] = await Promise.all([(0, _has_unset_value_for_field.hasUnsetValueForField)({
    apmEventClient,
    searchAggregatedTransactions,
    serviceName,
    fieldName: _apm.SERVICE_ENVIRONMENT,
    start,
    end
  }), (0, _get_suggestions_with_terms_aggregation.getSuggestionsWithTermsAggregation)({
    fieldName: _apm.SERVICE_ENVIRONMENT,
    fieldValue: '',
    searchAggregatedTransactions,
    serviceName,
    apmEventClient,
    size,
    start,
    end
  })]);
  const environments = resp.terms;
  if (hasUnsetEnvironments) {
    environments.push(_environment_filter_values.ENVIRONMENT_NOT_DEFINED.value);
  }
  return environments;
}