"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeployIntegration = void 0;
var _react = require("react");
var _common = require("../../../../../common");
var _telemetry = require("../../../telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeployIntegration = ({
  integrationSettings,
  result,
  celInputResult,
  connector
}) => {
  const telemetry = (0, _telemetry.useTelemetry)();
  const {
    http,
    notifications
  } = (0, _common.useKibana)().services;
  const [integrationFile, setIntegrationFile] = (0, _react.useState)(null);
  const [integrationName, setIntegrationName] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (http == null || connector == null || integrationSettings == null || (notifications === null || notifications === void 0 ? void 0 : notifications.toasts) == null || (result === null || result === void 0 ? void 0 : result.pipeline) == null || (result === null || result === void 0 ? void 0 : result.samplesFormat) == null) {
      return;
    }
    const abortController = new AbortController();
    const deps = {
      http,
      abortSignal: abortController.signal
    };
    (async () => {
      try {
        var _integrationSettings$, _integrationSettings$2, _integrationSettings$3, _integrationSettings$4, _integrationSettings$5, _integrationSettings$6, _integrationSettings$7, _integrationSettings$8, _result$docs, _result$samplesFormat;
        const parameters = {
          integration: {
            title: (_integrationSettings$ = integrationSettings.title) !== null && _integrationSettings$ !== void 0 ? _integrationSettings$ : '',
            description: (_integrationSettings$2 = integrationSettings.description) !== null && _integrationSettings$2 !== void 0 ? _integrationSettings$2 : '',
            name: (_integrationSettings$3 = integrationSettings.name) !== null && _integrationSettings$3 !== void 0 ? _integrationSettings$3 : '',
            logo: integrationSettings.logo,
            dataStreams: [{
              title: (_integrationSettings$4 = integrationSettings.dataStreamTitle) !== null && _integrationSettings$4 !== void 0 ? _integrationSettings$4 : '',
              description: (_integrationSettings$5 = integrationSettings.dataStreamDescription) !== null && _integrationSettings$5 !== void 0 ? _integrationSettings$5 : '',
              name: (_integrationSettings$6 = integrationSettings.dataStreamName) !== null && _integrationSettings$6 !== void 0 ? _integrationSettings$6 : '',
              inputTypes: (_integrationSettings$7 = integrationSettings.inputTypes) !== null && _integrationSettings$7 !== void 0 ? _integrationSettings$7 : [],
              rawSamples: (_integrationSettings$8 = integrationSettings.logSamples) !== null && _integrationSettings$8 !== void 0 ? _integrationSettings$8 : [],
              docs: (_result$docs = result.docs) !== null && _result$docs !== void 0 ? _result$docs : [],
              samplesFormat: (_result$samplesFormat = result.samplesFormat) !== null && _result$samplesFormat !== void 0 ? _result$samplesFormat : {
                name: 'json'
              },
              pipeline: result.pipeline,
              celInput: celInputResult
            }]
          }
        };
        setIsLoading(true);
        const zippedIntegration = await (0, _common.runBuildIntegration)(parameters, deps);
        if (abortController.signal.aborted) return;
        setIntegrationFile(zippedIntegration);
        const installResult = await (0, _common.runInstallPackage)(zippedIntegration, deps);
        if (abortController.signal.aborted) return;
        const integrationNameFromResponse = (0, _common.getIntegrationNameFromResponse)(installResult);
        if (integrationNameFromResponse) {
          setIntegrationName(integrationNameFromResponse);
          telemetry.reportAssistantComplete({
            integrationName: integrationNameFromResponse,
            integrationSettings,
            connector
          });
        } else {
          throw new Error('Integration name not found in response');
        }
      } catch (e) {
        var _integrationSettings$9;
        if (abortController.signal.aborted) return;
        const errorMessage = `${e.message}${e.body ? ` (${e.body.statusCode}): ${e.body.message}` : ''}`;
        telemetry.reportAssistantComplete({
          integrationName: (_integrationSettings$9 = integrationSettings.name) !== null && _integrationSettings$9 !== void 0 ? _integrationSettings$9 : '',
          integrationSettings,
          connector,
          error: errorMessage
        });
        setError(errorMessage);
      } finally {
        setIsLoading(false);
      }
    })();
    return () => {
      abortController.abort();
    };
  }, [setIntegrationFile, http, integrationSettings, connector, notifications === null || notifications === void 0 ? void 0 : notifications.toasts, result === null || result === void 0 ? void 0 : result.docs, result === null || result === void 0 ? void 0 : result.pipeline, result === null || result === void 0 ? void 0 : result.samplesFormat, celInputResult, telemetry]);
  return {
    isLoading,
    integrationFile,
    integrationName,
    error
  };
};
exports.useDeployIntegration = useDeployIntegration;