"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleHeaderError = handleHeaderError;
exports.handleKVError = handleKVError;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
var _constants = require("./constants");
var _processors = require("../../util/processors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleKVError({
  state,
  model
}) {
  const outputParser = new _output_parsers.JsonOutputParser();
  const kvErrorGraph = _prompts.KV_ERROR_PROMPT.pipe(model).pipe(outputParser);
  const proc = state.kvProcessor;
  const processor = proc[0].kv;
  const kvInput = await kvErrorGraph.invoke({
    current_processor: JSON.stringify(processor, null, 2),
    errors: JSON.stringify(state.errors, null, 2),
    common_errors: JSON.stringify(_constants.COMMON_ERRORS, null, 2),
    ex_answer: JSON.stringify(_constants.KV_EXAMPLE_ANSWER, null, 2)
  });
  const kvProcessor = (0, _processors.createKVProcessor)(kvInput, state);
  return {
    kvProcessor,
    lastExecutedChain: 'kvError'
  };
}
async function handleHeaderError({
  state,
  model
}) {
  const outputParser = new _output_parsers.JsonOutputParser();
  const kvHeaderErrorGraph = _prompts.KV_HEADER_ERROR_PROMPT.pipe(model).pipe(outputParser);
  const currentPattern = state.grokPattern;
  const pattern = await kvHeaderErrorGraph.invoke({
    packageName: state.packageName,
    dataStreamName: state.dataStreamName,
    current_pattern: JSON.stringify(currentPattern, null, 2),
    errors: JSON.stringify(state.errors, null, 2),
    ex_answer: JSON.stringify(_constants.KV_HEADER_ERROR_EXAMPLE_ANSWER, null, 2)
  });
  return {
    grokPattern: pattern.grok_pattern,
    lastExecutedChain: 'kv_header_error'
  };
}